/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class FloatSerializer
extends Serializer {
    private final float precision;
    private final boolean optimizePositive;

    public FloatSerializer() {
        this.precision = 0.0f;
        this.optimizePositive = false;
    }

    public FloatSerializer(float precision, boolean optimizePositive) {
        this.precision = precision;
        this.optimizePositive = optimizePositive;
    }

    public Float readObjectData(ByteBuffer buffer, Class type) {
        float f = this.precision == 0.0f ? buffer.getFloat() : (float)IntSerializer.get(buffer, this.optimizePositive) / this.precision;
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read float: " + f));
        }
        return Float.valueOf(f);
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        if (this.precision == 0.0f) {
            buffer.putFloat(((Float)object).floatValue());
        } else {
            IntSerializer.put(buffer, (int)(((Float)object).floatValue() * this.precision), this.optimizePositive);
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Wrote float: " + object));
        }
    }
}

