/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.stateless4j.conversion;

import com.googlecode.stateless4j.validation.Enforce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterConversion {
    public static Object Unpack(Object[] args, Class<?> argType, int index) throws Exception {
        Enforce.ArgumentNotNull(args, "args");
        if (args.length <= index) {
            throw new Exception(String.format("ArgOfTypeRequiredInPosition", argType, index));
        }
        Object arg = args[index];
        if (arg != null && !argType.isAssignableFrom(arg.getClass())) {
            throw new Exception(String.format("WrongArgType", index, arg.getClass(), argType));
        }
        return arg;
    }

    public static void Validate(Object[] args, Class<?>[] expected) throws Exception {
        if (args.length > expected.length) {
            throw new Exception(String.format("Trop de parametres", expected.length, args.length));
        }
        for (int i = 0; i < expected.length; ++i) {
            ParameterConversion.Unpack(args, expected[i], i);
        }
    }
}

