/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.helper;

import com.gwtplatform.dispatch.annotation.helper.ClassGenerationHelper;
import java.io.Writer;
import java.util.Collection;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class BuilderGenerationHelper
extends ClassGenerationHelper {
    private static final String SIMPLE_CLASS_NAME = "Builder";

    public BuilderGenerationHelper(Writer sourceWriter) {
        super(sourceWriter);
    }

    public void generateBuilderClass(String builderObjectSimpleClassName, Collection<VariableElement> requiredFields, Collection<VariableElement> optionalFields, String ... interfaces) {
        TreeSet<Modifier> builderModifiers = new TreeSet<Modifier>();
        builderModifiers.add(Modifier.PUBLIC);
        builderModifiers.add(Modifier.STATIC);
        this.generateClassHeader(SIMPLE_CLASS_NAME, null, builderModifiers, interfaces);
        this.println();
        this.println("  // Required parameters");
        for (VariableElement requiredField : requiredFields) {
            this.generateFieldDeclaration(requiredField, Modifier.PRIVATE, Modifier.FINAL);
        }
        this.println();
        this.println("  // Optional parameters - initialized to default values");
        for (VariableElement optionalField : optionalFields) {
            this.generateFieldDeclaration(optionalField, Modifier.PRIVATE);
        }
        this.generateConstructorUsingFields(SIMPLE_CLASS_NAME, requiredFields, Modifier.PUBLIC);
        for (VariableElement optionalField : optionalFields) {
            this.generateBuilderInvocationMethod(optionalField);
        }
        this.generateBuilderBuildMethod(builderObjectSimpleClassName);
        this.generateFooter();
    }

    public void generateCustomBuilderConstructor(String customClassName, Collection<VariableElement> fieldsToBePassedAndAssigned) {
        this.println();
        this.println("  private {0}({1} builder) {", customClassName, SIMPLE_CLASS_NAME);
        if (fieldsToBePassedAndAssigned != null) {
            for (VariableElement fieldToBeAssigned : fieldsToBePassedAndAssigned) {
                this.generateBuilderFieldAssignment(fieldToBeAssigned, fieldToBeAssigned.getSimpleName().toString());
            }
        }
        this.println("  }");
    }

    protected void generateBuilderBuildMethod(String builderObjectSimpleClassName) {
        this.println();
        this.println("  public {0} build() {", builderObjectSimpleClassName);
        this.println("    return new {0}(this);", builderObjectSimpleClassName);
        this.println("  }");
    }

    protected void generateBuilderFieldAssignment(VariableElement fieldElement, Object value) {
        this.println("    this.{0} = builder.{0};", fieldElement.getSimpleName());
    }

    protected void generateBuilderHeader() {
        this.println("public static class {0} {", SIMPLE_CLASS_NAME);
    }

    protected void generateBuilderInvocationMethod(VariableElement fieldElement) {
        this.println();
        this.println("  public {0} {1}({2}) {", SIMPLE_CLASS_NAME, fieldElement.getSimpleName(), this.manufactureField(fieldElement));
        this.generateFieldAssignment(fieldElement, fieldElement.getSimpleName());
        this.println("    return this;");
        this.println("  }");
    }
}

