/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.processor;

import com.gwtplatform.dispatch.annotation.helper.BuilderGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ClassGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.GenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ReflectionHelper;
import com.gwtplatform.dispatch.annotation.processor.GenProcessor;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@SupportedAnnotationTypes(value={"com.gwtplatform.dispatch.annotation.GenEvent"})
public class GenEventProcessor
extends GenProcessor {
    @Override
    public void process(Element eventElement) {
        try (GenerationHelper writer = null;){
            ReflectionHelper reflection = new ReflectionHelper(this.getEnvironment(), (TypeElement)eventElement);
            String eventElementSimpleName = reflection.getSimpleClassName();
            String eventSimpleName = eventElementSimpleName + "Event";
            String eventClassName = reflection.getClassName() + "Event";
            Writer sourceWriter = this.getEnvironment().getFiler().createSourceFile(eventClassName, eventElement).openWriter();
            writer = new BuilderGenerationHelper(sourceWriter);
            Collection<VariableElement> orderedElementFields = reflection.getOrderedFields();
            Collection<VariableElement> allFields = reflection.getNonConstantFields();
            Collection<VariableElement> optionalFields = reflection.getOptionalFields();
            Collection<VariableElement> requiredFields = reflection.getNonConstantFields();
            requiredFields.removeAll(optionalFields);
            writer.generatePackageDeclaration(reflection.getPackageName());
            writer.generateImports("com.google.gwt.event.shared.EventHandler", "com.google.gwt.event.shared.GwtEvent", "com.google.web.bindery.event.shared.HandlerRegistration", null, "com.google.gwt.event.shared.HasHandlers");
            ((ClassGenerationHelper)writer).generateClassHeader(eventSimpleName, "GwtEvent<" + eventSimpleName + "." + eventElementSimpleName + "Handler>", reflection.getClassRepresenter().getModifiers(), new String[0]);
            writer.generateFieldDeclarations(orderedElementFields);
            if (!optionalFields.isEmpty()) {
                writer.setWhitespaces(2);
                ((BuilderGenerationHelper)writer).generateBuilderClass(eventSimpleName, requiredFields, optionalFields, new String[0]);
                writer.resetWhitespaces();
                if (!requiredFields.isEmpty()) {
                    ((ClassGenerationHelper)writer).generateConstructorUsingFields(eventSimpleName, requiredFields, Modifier.PUBLIC);
                }
                ((BuilderGenerationHelper)writer).generateCustomBuilderConstructor(eventSimpleName, allFields);
                this.generateFireSelfMethod(writer);
            } else if (!requiredFields.isEmpty()) {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(eventSimpleName, Modifier.PROTECTED);
                ((ClassGenerationHelper)writer).generateConstructorUsingFields(eventSimpleName, requiredFields, Modifier.PUBLIC);
                this.generateFireFieldsStaticMethod(writer, requiredFields, eventSimpleName);
            } else {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(eventSimpleName, Modifier.PUBLIC);
                this.generateFireFieldsStaticMethod(writer, requiredFields, eventSimpleName);
            }
            this.generateFireInstanceStaticMethod(writer, eventSimpleName);
            this.generateHasHandlerInterface(writer, eventElementSimpleName);
            this.generateHandlerInterface(writer, eventElementSimpleName);
            this.generateStaticTypeField(writer, eventElementSimpleName);
            this.generateTypeAccessorMethod(writer, eventElementSimpleName);
            this.generateAssociatedTypeMethod(writer, eventElementSimpleName);
            this.generateDispatchMethod(writer, eventElementSimpleName);
            ((ClassGenerationHelper)writer).generateFieldAccessors(orderedElementFields);
            ((ClassGenerationHelper)writer).generateEquals(eventSimpleName, orderedElementFields);
            ((ClassGenerationHelper)writer).generateHashCode(orderedElementFields);
            ((ClassGenerationHelper)writer).generateToString(eventSimpleName, orderedElementFields);
            writer.generateFooter();
        }
    }

    protected void generateAssociatedTypeMethod(GenerationHelper writer, String eventSimpleName) {
        writer.println();
        writer.println("  @Override");
        writer.println("  public Type<{0}Handler> getAssociatedType() {", eventSimpleName);
        writer.println("    return TYPE;");
        writer.println("  }");
    }

    protected void generateDispatchMethod(GenerationHelper writer, String eventSimpleName) {
        writer.println();
        writer.println("  @Override");
        writer.println("  protected void dispatch({0}Handler handler) {", eventSimpleName);
        writer.println("    handler.on{0}(this);", eventSimpleName);
        writer.println("  }");
    }

    protected void generateHasHandlerInterface(GenerationHelper writer, String eventSimpleName) {
        writer.println();
        writer.println("  public interface Has{0}Handlers extends HasHandlers {", eventSimpleName);
        writer.println("    HandlerRegistration add{0}Handler({0}Handler handler);", eventSimpleName);
        writer.println("  }");
    }

    protected void generateHandlerInterface(GenerationHelper writer, String eventSimpleName) {
        writer.println();
        writer.println("  public interface {0}Handler extends EventHandler {", eventSimpleName);
        writer.println("    public void on{0}({0}Event event);", eventSimpleName);
        writer.println("  }");
    }

    protected void generateFireInstanceStaticMethod(GenerationHelper writer, String simpleClassName) {
        writer.println();
        writer.println("  public static void fire(HasHandlers source, {0} eventInstance) {", simpleClassName);
        writer.println("    source.fireEvent(eventInstance);");
        writer.println("  }");
    }

    protected void generateFireFieldsStaticMethod(GenerationHelper writer, Collection<VariableElement> requiredFields, String simpleClassName) {
        String fields = writer.generateFieldList(requiredFields, false, false);
        String fieldsWithTypes = writer.generateFieldList(requiredFields, true, requiredFields.size() > 0);
        writer.println();
        writer.println("  public static void fire(HasHandlers source{0}) {", fieldsWithTypes);
        writer.println("    {0} eventInstance = new {0}({1});", simpleClassName, fields);
        writer.println("    source.fireEvent(eventInstance);");
        writer.println("  }");
    }

    protected void generateFireSelfMethod(GenerationHelper writer) {
        writer.println();
        writer.println("  public void fire(HasHandlers source) {");
        writer.println("    source.fireEvent(this);");
        writer.println("  }");
    }

    protected void generateStaticTypeField(GenerationHelper out, String eventSimpleName) {
        out.println();
        out.println("  private static final Type<{0}Handler> TYPE = new Type<{0}Handler>();", eventSimpleName);
    }

    protected void generateTypeAccessorMethod(GenerationHelper out, String eventSimpleName) {
        out.println();
        out.println("  public static Type<{0}Handler> getType() {", eventSimpleName);
        out.println("    return TYPE;");
        out.println("  }");
    }
}

