/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.message.Trace;

public abstract class DbObjectBase
implements DbObject {
    protected Database database;
    protected Trace trace;
    protected String comment;
    private int id;
    private String objectName;
    private long modificationId;
    private boolean temporary;

    protected DbObjectBase(Database database, int n, String string, int n2) {
        this.database = database;
        this.trace = database.getTrace(n2);
        this.id = n;
        this.objectName = string;
        this.modificationId = database.getModificationMetaId();
    }

    @Override
    public abstract String getCreateSQL();

    @Override
    public abstract String getDropSQL();

    @Override
    public abstract void removeChildrenAndResources(Session var1);

    @Override
    public abstract void checkRename();

    public void setModified() {
        this.modificationId = this.database == null ? -1L : this.database.getNextModificationMetaId();
    }

    public long getModificationId() {
        return this.modificationId;
    }

    protected void setObjectName(String string) {
        this.objectName = string;
    }

    @Override
    public String getSQL() {
        return Parser.quoteIdentifier(this.objectName);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return Parser.quoteIdentifier(stringBuilder, this.objectName);
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        return null;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.objectName;
    }

    protected void invalidate() {
        if (this.id == -1) {
            throw DbException.throwInternalError();
        }
        this.setModified();
        this.id = -1;
        this.database = null;
        this.trace = null;
        this.objectName = null;
    }

    public final boolean isValid() {
        return this.id != -1;
    }

    @Override
    public void rename(String string) {
        this.checkRename();
        this.objectName = string;
        this.setModified();
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return this.objectName + ":" + this.id + ":" + super.toString();
    }
}

