/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.mojo;

import com.isomorphic.maven.packaging.Distribution;
import com.isomorphic.maven.packaging.Downloads;
import com.isomorphic.maven.packaging.License;
import com.isomorphic.maven.packaging.Module;
import com.isomorphic.maven.packaging.Product;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPackagerMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPackagerMojo.class);
    @Parameter(property="includeAnalytics", defaultValue="false")
    protected Boolean includeAnalytics;
    @Parameter(property="buildDate")
    protected String buildDate;
    @Parameter(property="buildNumber", required=true)
    protected String buildNumber;
    @Parameter(property="license", required=true)
    protected License license;
    @Parameter(property="includeMessaging", defaultValue="false")
    protected Boolean includeMessaging;
    @Parameter(property="overwrite", defaultValue="false")
    protected Boolean overwrite;
    @Parameter(property="skipDownload", defaultValue="false")
    protected Boolean skipDownload;
    @Parameter(property="skipExtraction", defaultValue="false")
    protected Boolean skipExtraction;
    @Parameter(property="product", defaultValue="SMARTGWT")
    protected Product product;
    @Parameter(property="snapshots", defaultValue="true")
    protected Boolean snapshots;
    @Parameter(property="workdir", defaultValue="${java.io.tmpdir}${project.artifactId}")
    protected File workdir;
    @Parameter(property="serverId", defaultValue="smartclient-developer")
    protected String serverId;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession repositorySystemSession;
    @Component
    protected ModelBuilder modelBuilder;
    @Component
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected Settings settings;

    public abstract void doExecute(Set<Module> var1) throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        if (this.buildDate == null) {
            this.buildDate = dateFormat.format(new Date());
        }
        try {
            dateFormat.parse(this.buildDate);
        }
        catch (ParseException e) {
            throw new MojoExecutionException(String.format("buildDate '%s' must take the form yyyy-MM-dd.", this.buildDate));
        }
        LOGGER.debug("buildDate set to '{}'", (Object)this.buildDate);
        String buildNumberFormat = "\\d.*\\.\\d.*[d|p]";
        if (!this.buildNumber.matches(buildNumberFormat)) {
            throw new MojoExecutionException(String.format("buildNumber '%s' must take the form [major].[minor].[d|p].  e.g., 4.1d", this.buildNumber, buildNumberFormat));
        }
        File basedir = FileUtils.getFile((File)this.workdir, (String[])new String[]{this.product.toString(), this.license.toString(), this.buildNumber, this.buildDate});
        ArrayList<License> licenses = new ArrayList<License>();
        licenses.add(this.license);
        if (this.license == License.POWER || this.license == License.ENTERPRISE) {
            if (this.includeAnalytics.booleanValue()) {
                licenses.add(License.ANALYTICS_MODULE);
            }
            if (this.includeMessaging.booleanValue()) {
                licenses.add(License.MESSAGING_MODULE);
            }
        }
        Set<Module> artifacts = this.collect(licenses, basedir);
        File bookmarkable = new File(basedir.getParent(), "latest");
        LOGGER.info("Copying distribution to '{}'", (Object)bookmarkable.getAbsolutePath());
        try {
            FileUtils.forceMkdir((File)bookmarkable);
            FileUtils.cleanDirectory((File)bookmarkable);
            FileUtils.copyDirectory((File)basedir, (File)bookmarkable, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"zip")));
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to copy distribution contents", (Throwable)e);
        }
        this.doExecute(artifacts);
    }

    private Set<Module> collect(List<License> downloads, File basedir) throws MojoExecutionException {
        Server server = this.settings.getServer(this.serverId);
        String username = null;
        String password = null;
        if (server != null) {
            username = server.getUsername();
            password = server.getPassword();
        } else {
            LOGGER.warn("No server configured with id '{}'.  Will be unable to authenticate.", (Object)this.serverId);
        }
        UsernamePasswordCredentials credentials = null;
        if (username != null) {
            credentials = new UsernamePasswordCredentials(username, password);
        }
        File downloadTo = new File(basedir, "zip");
        downloadTo.mkdirs();
        Downloads downloadManager = new Downloads(credentials);
        downloadManager.setToFolder(downloadTo);
        downloadManager.setProxyConfiguration(this.settings.getActiveProxy());
        downloadManager.setOverwriteExistingFiles(this.overwrite);
        File[] existing = downloadTo.listFiles();
        ArrayList<Distribution> distributions = new ArrayList<Distribution>();
        try {
            Collection files;
            if (!this.skipDownload.booleanValue()) {
                distributions.addAll(downloadManager.fetch(this.product, this.buildNumber, this.buildDate, downloads.toArray(new License[0])));
            } else if (existing != null) {
                LOGGER.info("Creating local distribution from '{}'", (Object)downloadTo.getAbsolutePath());
                Distribution distribution = Distribution.get(this.product, this.license, this.buildNumber, this.buildDate);
                distribution.getFiles().addAll(Arrays.asList(existing));
                distributions.add(distribution);
            }
            if (!this.skipExtraction.booleanValue()) {
                LOGGER.info("Unpacking downloaded file/s to '{}'", (Object)basedir);
                for (Distribution distribution : distributions) {
                    distribution.unpack(basedir);
                }
            }
            if ((files = FileUtils.listFiles((File)basedir, (IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"jar"), FileFilterUtils.suffixFileFilter((String)"xml"), FileFilterUtils.suffixFileFilter((String)"zip")}), (IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.nameFileFilter((String)"lib"), FileFilterUtils.nameFileFilter((String)"pom"), FileFilterUtils.nameFileFilter((String)"assembly")}))).isEmpty()) {
                throw new MojoExecutionException(String.format("There don't appear to be any files to work with at '%s'.  Check earlier log entries for clues.", basedir.getAbsolutePath()));
            }
            TreeSet<Module> result = new TreeSet<Module>();
            for (File file : files) {
                try {
                    String base = FilenameUtils.getBaseName((String)file.getName().replaceAll("_", "-"));
                    if ("xml".equals(FilenameUtils.getExtension((String)file.getName()))) {
                        result.add(new Module(this.getModelFromFile(file)));
                        continue;
                    }
                    WildcardFileFilter filter = new WildcardFileFilter(base + ".pom");
                    Collection poms = FileUtils.listFiles((File)basedir, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE);
                    if (poms.size() != 1) {
                        LOGGER.warn("Expected to find exactly 1 POM matching artifact with name '{}', but found {}.  Skpping installation.", (Object)base, (Object)poms.size());
                        continue;
                    }
                    Model model = this.getModelFromFile((File)poms.iterator().next());
                    Module module = new Module(model, file);
                    int index = base.indexOf("-");
                    String prefix = base.substring(0, index);
                    Collection doc = FileUtils.listFiles((File)new File(basedir, "doc"), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (IOFileFilter)FileFilterUtils.nameFileFilter((String)"lib"));
                    if (doc.size() != 1) {
                        LOGGER.debug("Found {} javadoc attachments with prefix '{}'.  Skipping attachment.", (Object)doc.size(), (Object)prefix);
                    } else {
                        module.attach((File)doc.iterator().next(), "javadoc");
                    }
                    result.add(module);
                }
                catch (ModelBuildingException e) {
                    throw new MojoExecutionException("Error building model from POM", (Exception)((Object)e));
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure during assembly collection", (Exception)e);
        }
    }

    private Model getModelFromFile(File pom) throws ModelBuildingException, IOException {
        if (this.buildNumber.endsWith("d") && !this.snapshots.booleanValue()) {
            LOGGER.info("Rewriting POM file to remove SNAPSHOT qualifier from development build.");
            String content = FileUtils.readFileToString((File)pom);
            content = content.replaceAll("-SNAPSHOT", "");
            FileUtils.write((File)pom, (CharSequence)content);
        }
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setPomFile(pom);
        ModelBuildingResult result = this.modelBuilder.build((ModelBuildingRequest)request);
        return result.getEffectiveModel();
    }
}

