/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.mojo;

import com.isomorphic.maven.mojo.AbstractPackagerMojo;
import com.isomorphic.maven.packaging.Module;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", requiresProject=false)
public final class DeployMojo
extends AbstractPackagerMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployMojo.class);
    @Parameter(property="repositoryId")
    private String repositoryId;
    @Parameter(property="repositoryUrl", required=true)
    private String repositoryUrl;
    @Parameter(property="repositoryType", defaultValue="default")
    private String repositoryType;

    @Override
    public void doExecute(Set<Module> artifacts) throws MojoExecutionException, MojoFailureException {
        for (Module artifact : artifacts) {
            DeployRequest deployRequest = new DeployRequest();
            deployRequest.addArtifact((Artifact)artifact);
            for (Artifact subArtifact : artifact.getAttachments()) {
                deployRequest.addArtifact(subArtifact);
            }
            try {
                RemoteRepository repository = new RemoteRepository.Builder(this.repositoryId, this.repositoryType, this.repositoryUrl).build();
                deployRequest.setRepository(repository);
                this.repositorySystem.deploy(this.repositorySystemSession, deployRequest);
            }
            catch (DeploymentException e) {
                throw new MojoFailureException("Deployment failed: ", (Throwable)e);
            }
        }
    }
}

