/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.packaging;

import com.isomorphic.maven.packaging.Distribution;
import com.isomorphic.maven.packaging.License;
import com.isomorphic.maven.packaging.Product;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.util.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloads {
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloads.class);
    private static final String DOMAIN = "www.smartclient.com";
    private static final String LOGIN_URL = "/devlogin/login.jsp";
    private static final String LOGOUT_URL = "/logout.jsp";
    private File toFolder = new File(System.getProperty("java.io.tmpdir"));
    private Boolean overwriteExistingFiles = Boolean.FALSE;
    private Proxy proxyConfiguration;
    private UsernamePasswordCredentials credentials;
    private DefaultHttpClient httpClient = new DefaultHttpClient();
    private HttpHost host = new HttpHost("www.smartclient.com");

    public Downloads(UsernamePasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public void setProxyConfiguration(Proxy proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public void setToFolder(File toFolder) {
        this.toFolder = toFolder;
    }

    public void setOverwriteExistingFiles(Boolean overwriteExistingFiles) {
        this.overwriteExistingFiles = overwriteExistingFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Distribution> fetch(Product product, String buildNumber, String buildDate, License ... licenses) throws MojoExecutionException {
        try {
            this.setup();
            this.login();
            ArrayList<Distribution> result = new ArrayList<Distribution>();
            for (License license : licenses) {
                Distribution distribution = Distribution.get(product, license, buildNumber, buildDate);
                this.download(distribution);
                result.add(distribution);
            }
            this.logout();
            ArrayList<Distribution> arrayList = result;
            return arrayList;
        }
        finally {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    private void download(Distribution distribution) throws MojoExecutionException {
        String[] links;
        for (String link : links = this.list(distribution)) {
            HttpResponse response;
            String filename = FilenameUtils.getName((String)link);
            File file = new File(this.toFolder, filename);
            if (file.exists() && !this.overwriteExistingFiles.booleanValue()) {
                LOGGER.info("Existing archive found at '{}'.  Skipping download.", (Object)file.getAbsolutePath());
                distribution.getFiles().add(file);
                continue;
            }
            HttpGet httpget = new HttpGet(link);
            try {
                response = this.httpClient.execute(this.host, (HttpRequest)httpget);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error issuing GET request for bundle at '" + httpget + "'", e);
            }
            HttpEntity entity = response.getEntity();
            if (!this.toFolder.mkdirs() && !this.toFolder.exists()) {
                throw new MojoExecutionException("Could not create specified working directory '" + this.toFolder.getAbsolutePath() + "'");
            }
            FileUtils.deleteQuietly((File)file);
            try {
                LOGGER.info("Downloading file to '{}'", (Object)file.getAbsolutePath());
                entity.writeTo((OutputStream)new FileOutputStream(file));
                distribution.getFiles().add(file);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error writing file to '" + file.getAbsolutePath() + "'", e);
            }
        }
    }

    private String[] list(Distribution dist) throws MojoExecutionException {
        Document doc;
        HttpResponse response;
        HttpGet request = new HttpGet(dist.getRemoteIndex());
        try {
            LOGGER.debug("Requesting list of files from {}{}", (Object)DOMAIN, (Object)dist.getRemoteIndex());
            response = this.httpClient.execute(this.host, (HttpRequest)request);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error issuing GET request for bundle at '" + request + "'", e);
        }
        try {
            String html = EntityUtils.toString((HttpEntity)response.getEntity());
            doc = Jsoup.parse((String)html);
            doc.outputSettings().prettyPrint(true);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing response from '" + request + "'", e);
        }
        ArrayList<String> result = new ArrayList<String>();
        Elements links = doc.select(dist.getRemoteIndexFilter());
        for (Element element : links) {
            String href = element.attr("href");
            result.add(href);
        }
        if (result.isEmpty()) {
            String msg = String.format("No downloads found at '%s%s'.  Response from server: \n\n%s\n", DOMAIN, dist.getRemoteIndex(), doc.html());
            LOGGER.warn(msg);
        }
        return result.toArray(new String[0]);
    }

    private void login() throws MojoExecutionException {
        if (this.credentials == null) {
            return;
        }
        String username = this.credentials.getUserName();
        String password = this.credentials.getPassword();
        LOGGER.info("Authenticating to '{}' with username: '{}'", (Object)"www.smartclient.com/devlogin/login.jsp", (Object)username);
        HttpPost login = new HttpPost(LOGIN_URL);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("USERNAME", username));
        nvps.add(new BasicNameValuePair("PASSWORD", password));
        try {
            login.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            HttpResponse response = this.httpClient.execute(this.host, (HttpRequest)login);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during POST request for authentication", (Exception)e);
        }
    }

    private void logout() {
        HttpPost logout = new HttpPost(LOGOUT_URL);
        LOGGER.info("Logging off at '{}'", (Object)"www.smartclient.com/logout.jsp");
        try {
            HttpResponse response = this.httpClient.execute(this.host, (HttpRequest)logout);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            LOGGER.warn("Error at logout ", (Throwable)e);
        }
    }

    private void setup() throws MojoExecutionException {
        try {
            if (this.proxyConfiguration != null && this.isProxied(this.proxyConfiguration)) {
                if (this.proxyConfiguration.getUsername() != null) {
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.proxyConfiguration.getHost(), this.proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword()));
                }
                HttpHost proxy = new HttpHost(this.proxyConfiguration.getHost(), this.proxyConfiguration.getPort());
                this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error obtaining Maven settings", e);
        }
    }

    private boolean isProxied(Proxy proxyConfig) throws MalformedURLException {
        String nonProxyHostsAsString = proxyConfig.getNonProxyHosts();
        for (String nonProxyHost : StringUtils.split((String)nonProxyHostsAsString, (String)",;|")) {
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                int pos = nonProxyHost.indexOf(42);
                String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && DOMAIN.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return false;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && DOMAIN.endsWith(nonProxyHostSuffix)) {
                    return false;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !DOMAIN.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !DOMAIN.endsWith(nonProxyHostSuffix)) continue;
                return false;
            }
            if (!DOMAIN.equals(nonProxyHost)) continue;
            return false;
        }
        return true;
    }
}

