/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.maven.packaging;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.SubArtifact;

public class Module
extends AbstractArtifact
implements Comparable<Module> {
    String groupId = "";
    String artifactId = "";
    String version = "";
    String classifier = "";
    String extension = "";
    File file;
    Map<String, String> propertiesMap = new HashMap<String, String>(0);
    Set<Artifact> subs = new HashSet<Artifact>();

    public Module(Model model) {
        this(model, model.getPomFile());
    }

    public Module(Model model, File file) {
        this.file = file;
        this.artifactId = model.getArtifactId();
        this.groupId = model.getGroupId();
        this.version = model.getVersion();
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        String string = this.extension = fileExtension.equalsIgnoreCase("xml") ? "pom" : fileExtension;
        if (!this.extension.equals("pom") && model.getPomFile() != null) {
            this.attach(model.getPomFile(), null);
        }
    }

    public Boolean isPom() {
        return this.extension.equalsIgnoreCase("pom");
    }

    public void attach(File file, String classifier) {
        this.subs.add((Artifact)new SubArtifact((Artifact)this, classifier, FilenameUtils.getExtension((String)file.getName()), file));
    }

    public Artifact[] getAttachments() {
        return this.subs.toArray(new Artifact[0]);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public Artifact setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public File getFile() {
        return this.file;
    }

    public Artifact setFile(File file) {
        this.file = file;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getProperty(String key, String defaultValue) {
        return this.propertiesMap.containsKey(key) ? this.propertiesMap.get(key) : defaultValue;
    }

    public Map<String, String> getProperties() {
        return this.propertiesMap;
    }

    public Artifact setProperties(Map<String, String> properties) {
        this.propertiesMap = properties;
        return this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof Module)) {
            return false;
        }
        return this.toString().equals(that.toString());
    }

    @Override
    public int compareTo(Module o) {
        return this.toString().compareTo(o.toString());
    }
}

