/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.portal.tools.ExtInfoBuilder;
import com.liferay.portal.util.FileImpl;
import com.liferay.util.ant.CopyTask;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class ExtBuilderMojo
extends AbstractMojo {
    private static FileImpl _fileUtil = new FileImpl();
    private ArchiverManager archiverManager;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localArtifactRepository;
    private String pluginName;
    private MavenProject project;
    protected MavenProjectBuilder projectBuilder;
    private List remoteArtifactRepositories;
    private File sqlSourceDir;
    private File webappDir;
    private File workDir;

    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void doExecute() throws Exception {
        File implDir = new File(this.webappDir, "WEB-INF/ext-impl");
        implDir.mkdirs();
        File implClassesDir = new File(implDir, "classes/com/liferay/portal/deploy/dependencies");
        implClassesDir.mkdirs();
        File globalLibDir = new File(this.webappDir, "WEB-INF/ext-lib/global");
        globalLibDir.mkdirs();
        File portalLibDir = new File(this.webappDir, "WEB-INF/ext-lib/portal");
        portalLibDir.mkdirs();
        File serviceDir = new File(this.webappDir, "WEB-INF/ext-service");
        serviceDir.mkdirs();
        File sqlDir = new File(this.webappDir, "WEB-INF/sql");
        sqlDir.mkdirs();
        File utilBridgesDir = new File(this.webappDir, "WEB-INF/ext-util-bridges");
        utilBridgesDir.mkdirs();
        File utilJavaDir = new File(this.webappDir, "WEB-INF/ext-util-java");
        utilJavaDir.mkdirs();
        File utilTaglibDir = new File(this.webappDir, "WEB-INF/ext-util-taglib");
        utilTaglibDir.mkdirs();
        File webDir = new File(this.webappDir, "WEB-INF/ext-web/docroot");
        webDir.mkdirs();
        this.workDir.mkdirs();
        String groupId = this.project.getGroupId();
        File extImplFile = null;
        for (Object dependencyObj : this.project.getDependencies()) {
            Dependency dependency = (Dependency)dependencyObj;
            if (!groupId.equals(dependency.getGroupId())) continue;
            Artifact artifact = this.resolveArtifact(dependency);
            String artifactId = artifact.getArtifactId();
            if (artifactId.endsWith("ext-impl")) {
                extImplFile = artifact.getFile();
                this.copyJarAndClasses(artifact, implDir, "ext-impl.jar");
                continue;
            }
            if (artifactId.endsWith("ext-lib-global")) {
                this.copyLibraryDependencies(globalLibDir, artifact);
                continue;
            }
            if (artifactId.endsWith("ext-lib-portal")) {
                this.copyLibraryDependencies(portalLibDir, artifact);
                continue;
            }
            if (artifactId.endsWith("ext-service")) {
                this.copyJarAndClasses(artifact, serviceDir, "ext-service.jar");
                continue;
            }
            if (artifactId.endsWith("ext-util-bridges")) {
                this.copyUtilLibrary(artifact, utilBridgesDir, implClassesDir, "util-bridges.jar");
                continue;
            }
            if (artifactId.endsWith("ext-util-java")) {
                this.copyUtilLibrary(artifact, utilJavaDir, implClassesDir, "util-java.jar");
                continue;
            }
            if (artifactId.endsWith("ext-util-taglib")) {
                this.copyUtilLibrary(artifact, utilTaglibDir, implClassesDir, "util-taglib.jar");
                continue;
            }
            if (!artifactId.endsWith("ext-web")) continue;
            String[] excludes = new String[]{"META-INF/**"};
            this.unpack(artifact.getFile(), webDir, excludes, null);
        }
        this.unpack(extImplFile, this.workDir, null, new String[]{"portal-*.properties", "system-*.properties"});
        CopyTask.copyDirectory((File)this.workDir, (File)new File(webDir, "WEB-INF/classes"), (String)"portal-*.properties,system-*.properties", null);
        _fileUtil.copyDirectory(this.sqlSourceDir, sqlDir);
        String dirName = this.webappDir.getAbsolutePath() + "/WEB-INF";
        ExtInfoBuilder infoBuilder = new ExtInfoBuilder(dirName, dirName, this.pluginName);
    }

    protected void copyJarAndClasses(Artifact artifact, File jarDir, String jarName) throws Exception {
        File serviceJarFile = new File(jarDir, jarName);
        _fileUtil.copyFile(artifact.getFile(), serviceJarFile);
        File classesDir = new File(jarDir, "classes");
        classesDir.mkdirs();
        String[] excludes = new String[]{"META-INF/**", "portal-*.properties", "system-*.properties"};
        this.unpack(artifact.getFile(), classesDir, excludes, null);
    }

    protected void copyLibraryDependencies(File libDir, Artifact artifact) throws Exception {
        MavenProject libProject = this.resolveProject(artifact);
        List dependencies = libProject.getDependencies();
        for (Dependency dependency : dependencies) {
            String type;
            String scope = dependency.getScope();
            if (scope.equalsIgnoreCase("provided") || scope.equalsIgnoreCase("test") || (type = dependency.getType()).equalsIgnoreCase("pom")) continue;
            Artifact libArtifact = this.resolveArtifact(dependency);
            File libJarFile = new File(libDir, libArtifact.getArtifactId() + ".jar");
            _fileUtil.copyFile(libArtifact.getFile(), libJarFile);
        }
    }

    protected void copyUtilLibrary(Artifact artifact, File utilDir, File implClassesDir, String utilJarName) throws Exception {
        File utilJarFile = new File(utilDir, "ext-" + utilJarName);
        _fileUtil.copyFile(artifact.getFile(), utilJarFile);
        File dependencyUtilJarFile = new File(implClassesDir, "ext-" + this.pluginName + "-" + utilJarName);
        _fileUtil.copyFile(artifact.getFile(), dependencyUtilJarFile);
    }

    protected Dependency createDependency(String groupId, String artifactId, String version, String type) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setGroupId(groupId);
        dependency.setType(type);
        dependency.setVersion(version);
        return dependency;
    }

    protected Artifact resolveArtifact(Dependency dependency) throws Exception {
        Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
        this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localArtifactRepository);
        return artifact;
    }

    protected MavenProject resolveProject(Artifact artifact) throws Exception {
        Artifact pomArtifact = artifact;
        String type = artifact.getType();
        if (!type.equals("pom")) {
            pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        }
        return this.projectBuilder.buildFromRepository(pomArtifact, this.remoteArtifactRepositories, this.localArtifactRepository);
    }

    protected void unpack(File srcFile, File destDir, String[] excludes, String[] includes) throws Exception {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(srcFile);
        unArchiver.setDestDirectory(destDir);
        unArchiver.setSourceFile(srcFile);
        IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
        includeExcludeFileSelector.setExcludes(excludes);
        includeExcludeFileSelector.setIncludes(includes);
        unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
        unArchiver.extract();
    }
}

