/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.deploy.ExtDeployer;
import com.liferay.portal.tools.deploy.HookDeployer;
import com.liferay.portal.tools.deploy.LayoutTemplateDeployer;
import com.liferay.portal.tools.deploy.PortletDeployer;
import com.liferay.portal.tools.deploy.ThemeDeployer;
import com.liferay.portal.tools.deploy.WebDeployer;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.Portal;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class PluginDirectDeployerMojo
extends AbstractMojo {
    private String appServerType;
    private ArchiverManager archiverManager;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private String baseDir;
    private boolean customPortletXml;
    private File deployDir;
    private String jbossPrefix;
    private String liferayVersion;
    private ArtifactRepository localArtifactRepository;
    private String pluginType;
    private List remoteArtifactRepositories;
    private boolean unpackWar;
    private File warFile;
    private String warFileName;
    private File workDir;

    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void doExecute() throws Exception {
        if (!this.warFile.exists()) {
            this.getLog().error((CharSequence)(this.warFileName + " does not exist"));
            throw new FileNotFoundException(this.warFileName + " does not exist!");
        }
        this.getLog().info((CharSequence)("Directly deploying " + this.warFileName));
        this.getLog().debug((CharSequence)("appServerType: " + this.appServerType));
        this.getLog().debug((CharSequence)("baseDir: " + this.baseDir));
        this.getLog().debug((CharSequence)("deployDir: " + this.deployDir.getAbsolutePath()));
        this.getLog().debug((CharSequence)("jbossPrefix: " + this.jbossPrefix));
        this.getLog().debug((CharSequence)("pluginType: " + this.pluginType));
        this.getLog().debug((CharSequence)("unpackWar: " + this.unpackWar));
        this.preparePortalDependencies();
        System.setProperty("deployer.app.server.type", this.appServerType);
        System.setProperty("deployer.base.dir", this.baseDir);
        System.setProperty("deployer.dest.dir", this.deployDir.getAbsolutePath());
        System.setProperty("deployer.file.pattern", this.warFileName);
        System.setProperty("deployer.unpack.war", String.valueOf(this.unpackWar));
        System.setProperty("liferay.lib.portal.dir", this.workDir.getAbsolutePath() + "/WEB-INF/lib");
        this.initPortal();
        if (this.pluginType.equals("ext")) {
            this.deployExt();
        } else if (this.pluginType.equals("hook")) {
            this.deployHook();
        } else if (this.pluginType.equals("layouttpl")) {
            this.deployLayoutTemplate();
        } else if (this.pluginType.equals("portlet")) {
            this.deployPortlet();
        } else if (this.pluginType.equals("theme")) {
            this.deployTheme();
        } else if (this.pluginType.equals("web")) {
            this.deployWeb();
        }
    }

    protected void deployExt() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.workDir.getAbsolutePath() + "/WEB-INF/lib";
        jars.add(libPath + "/util-java.jar");
        new ExtDeployer(wars, jars);
    }

    protected void deployHook() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.workDir.getAbsolutePath() + "/WEB-INF/lib";
        jars.add(libPath + "/util-java.jar");
        new HookDeployer(wars, jars);
    }

    protected void deployLayoutTemplate() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList jars = new ArrayList();
        new LayoutTemplateDeployer(wars, jars);
    }

    protected void deployPortlet() throws Exception {
        String tldPath = this.workDir.getAbsolutePath() + "/WEB-INF/tld";
        System.setProperty("deployer.aui.taglib.dtd", tldPath + "/aui.tld");
        System.setProperty("deployer.custom.portlet.xml", String.valueOf(this.customPortletXml));
        System.setProperty("deployer.portlet.taglib.dtd", tldPath + "/liferay-portlet.tld");
        System.setProperty("deployer.portlet-ext.taglib.dtd", tldPath + "/liferay-portlet-ext.tld");
        System.setProperty("deployer.security.taglib.dtd", tldPath + "/liferay-security.tld");
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.ui.taglib.dtd", tldPath + "/liferay-ui.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.workDir.getAbsolutePath() + "/WEB-INF/lib";
        jars.add(libPath + "/util-bridges.jar");
        jars.add(libPath + "/util-java.jar");
        jars.add(libPath + "/util-taglib.jar");
        new PortletDeployer(wars, jars);
    }

    protected void deployTheme() throws Exception {
        String tldPath = this.workDir.getAbsolutePath() + "/WEB-INF/tld";
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.workDir.getAbsolutePath() + "/WEB-INF/lib";
        jars.add(libPath + "/util-java.jar");
        jars.add(libPath + "/util-taglib.jar");
        new ThemeDeployer(wars, jars);
    }

    protected void deployWeb() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.workDir.getAbsolutePath() + "/WEB-INF/lib";
        jars.add(libPath + "/util-java.jar");
        new WebDeployer(wars, jars);
    }

    protected void initPortal() {
        InitUtil.init();
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)new BeanLocatorImpl(null, null));
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        HtmlUtil htmlUtil = new HtmlUtil();
        htmlUtil.setHtml((Html)new HtmlImpl());
        PortalUtil portalUtil = new PortalUtil();
        portalUtil.setPortal((Portal)new PortalImpl());
        SAXReaderUtil saxReaderUtil = new SAXReaderUtil();
        saxReaderUtil.setSAXReader((SAXReader)new SAXReaderImpl());
    }

    protected void preparePortalDependencies() throws Exception {
        Artifact artifact = this.artifactFactory.createArtifact("com.liferay.portal", "portal-web", this.liferayVersion, "", "war");
        this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localArtifactRepository);
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
        unArchiver.setDestDirectory(this.workDir);
        unArchiver.setSourceFile(artifact.getFile());
        IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
        includeExcludeFileSelector.setExcludes(new String[0]);
        includeExcludeFileSelector.setIncludes(new String[]{"WEB-INF/tld/**", "WEB-INF/lib/**"});
        unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
        unArchiver.extract();
    }
}

