/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;

public class ServiceBuilderMojo
extends AbstractMojo {
    private String apiBaseDir;
    private String apiDir;
    private boolean autoNamespaceTables;
    private String baseDir;
    private String beanLocatorUtil;
    private String hbmFileName;
    private String implBaseDir;
    private String implDir;
    private String implResourcesDir;
    private Invoker invoker;
    private String jsonFileName;
    private String modelHintsFileName;
    private String ormFileName;
    private String pluginName;
    private String pluginType;
    private boolean postBuildDependencyModules;
    private List<String> postBuildGoals;
    private MavenProject project;
    private String propsUtil;
    private String remotingFileName;
    private String serviceFileName;
    private String springBaseFileName;
    private String springClusterFileName;
    private String springDynamicDataSourceFileName;
    private String springFileName;
    private String springHibernateFileName;
    private String springInfrastructureFileName;
    private String springShardDataSourceFileName;
    private String sqlDir;
    private String sqlFileName;
    private String sqlIndexesFileName;
    private String sqlIndexesPropertiesFileName;
    private String sqlSequencesFileName;
    private String webappBaseDir;

    public void execute() throws MojoExecutionException {
        try {
            this.initClassLoader();
            this.doExecute();
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                throw (MojoExecutionException)e;
            }
            throw new MojoExecutionException("Unable to execute Service Builder: " + e.getMessage(), e);
        }
    }

    protected void copyServicePropertiesFile() throws Exception {
        File servicePropertiesFile = new File(this.implResourcesDir, "service.properties");
        if (servicePropertiesFile.exists()) {
            FileUtil.copyFile((File)servicePropertiesFile, (File)new File(this.implDir, "service.properties"));
        }
    }

    protected void doExecute() throws Exception {
        this.initProperties();
        File inputFile = new File(this.serviceFileName);
        if (!inputFile.exists()) {
            throw new MojoExecutionException("Unable to find service.xml with path: " + inputFile.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Building from " + this.serviceFileName));
        PropsUtil.set((String)"spring.configs", (String)"META-INF/service-builder-spring.xml");
        PropsUtil.set((String)"resource.actions.read.portlet.resources", (String)"false");
        InitUtil.initWithSpring();
        this.copyServicePropertiesFile();
        FileUtil.mkdirs((String)this.sqlDir);
        File tempServiceFile = null;
        if (this.pluginType.equals("ext") && this.serviceFileName.contains("/main/resources/")) {
            File serviceFile = new File(this.serviceFileName);
            tempServiceFile = new File(StringUtil.replace((String)this.serviceFileName, (String)"/main/resources/", (String)"/main/java/"));
            FileUtil.copyFile((File)serviceFile, (File)tempServiceFile);
        }
        new ServiceBuilder(this.serviceFileName, this.hbmFileName, this.ormFileName, this.modelHintsFileName, this.springFileName, this.springBaseFileName, this.springClusterFileName, this.springDynamicDataSourceFileName, this.springHibernateFileName, this.springInfrastructureFileName, this.springShardDataSourceFileName, this.apiDir, this.implDir, this.jsonFileName, this.remotingFileName, this.sqlDir, this.sqlFileName, this.sqlIndexesFileName, this.sqlIndexesPropertiesFileName, this.sqlSequencesFileName, this.autoNamespaceTables, this.beanLocatorUtil, this.propsUtil, this.pluginName, null);
        if (tempServiceFile != null) {
            FileUtil.delete((File)tempServiceFile);
        }
        this.moveServicePropertiesFile();
        this.invokeDependencyBuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClassLoader() throws Exception {
        Class<ServiceBuilderMojo> clazz = ServiceBuilderMojo.class;
        synchronized (ServiceBuilderMojo.class) {
            Class<?> clazz2 = ((Object)((Object)this)).getClass();
            URLClassLoader classLoader = (URLClassLoader)clazz2.getClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (Object object : this.project.getCompileClasspathElements()) {
                String path = (String)object;
                File file = new File(path);
                URI uri = file.toURI();
                method.invoke((Object)classLoader, uri.toURL());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initProperties() {
        String webappResourcesDir;
        String webappDir;
        if (Validator.isNotNull((String)this.apiBaseDir) || Validator.isNotNull((String)this.implBaseDir) || Validator.isNotNull((String)this.webappBaseDir)) {
            if (Validator.isNull((String)this.apiBaseDir)) {
                this.apiBaseDir = this.baseDir;
            }
            if (Validator.isNull((String)this.implBaseDir) && Validator.isNotNull((String)this.webappBaseDir)) {
                this.implBaseDir = this.webappBaseDir;
            } else if (Validator.isNull((String)this.implBaseDir) && Validator.isNotNull((String)this.apiBaseDir)) {
                this.implBaseDir = this.baseDir;
            }
            if (Validator.isNull((String)this.webappBaseDir) && Validator.isNotNull((String)this.implBaseDir)) {
                this.webappBaseDir = this.implBaseDir;
            } else if (Validator.isNull((String)this.webappBaseDir) && Validator.isNotNull((String)this.apiBaseDir)) {
                this.webappBaseDir = this.baseDir;
            }
        }
        if (Validator.isNotNull((String)this.apiBaseDir)) {
            this.apiDir = this.apiBaseDir.concat("/src/main/java");
        }
        if (Validator.isNotNull((String)this.implBaseDir)) {
            this.implDir = this.implBaseDir.concat("/src/main/java");
            this.implResourcesDir = this.implBaseDir.concat("/src/main/resources");
            if (this.pluginType.equals("ext")) {
                this.hbmFileName = this.implResourcesDir.concat("/META-INF/ext-hbm.xml");
                this.modelHintsFileName = this.implResourcesDir.concat("/META-INF/ext-model-hints.xml");
                this.ormFileName = this.implResourcesDir.concat("/META-INF/ext-orm.xml");
                this.springFileName = this.implResourcesDir.concat("/META-INF/ext-spring.xml");
            }
        }
        if (Validator.isNotNull((String)this.webappBaseDir)) {
            webappDir = this.webappBaseDir.concat("/src/main/webapp");
            webappResourcesDir = this.webappBaseDir.concat("/src/main/resources");
            if (this.pluginType.equals("ext")) {
                this.jsonFileName = webappDir.concat("/html/js/liferay/service.js");
                this.remotingFileName = webappDir.concat("/WEB-INF/remoting-servlet-ext.xml");
            } else {
                this.hbmFileName = webappResourcesDir.concat("/META-INF/portlet-hbm.xml");
                this.jsonFileName = webappDir.concat("/js/service.js");
                this.modelHintsFileName = webappResourcesDir.concat("/META-INF/portlet-model-hints.xml");
                this.ormFileName = webappResourcesDir.concat("/META-INF/portlet-orm.xml");
                this.serviceFileName = webappDir.concat("/WEB-INF/service.xml");
                this.springBaseFileName = webappResourcesDir.concat("/META-INF/base-spring.xml");
                this.springClusterFileName = webappResourcesDir.concat("/META-INF/cluster-spring.xml");
                this.springDynamicDataSourceFileName = webappResourcesDir.concat("/META-INF/dynamic-data-source-spring.xml");
                this.springFileName = webappResourcesDir.concat("/META-INF/portlet-spring.xml");
                this.springHibernateFileName = webappResourcesDir.concat("/META-INF/hibernate-spring.xml");
                this.springInfrastructureFileName = webappResourcesDir.concat("/META-INF/infrastructure-spring.xml");
                this.springShardDataSourceFileName = webappResourcesDir.concat("/META-INF/shard-data-source-spring.xml");
                this.sqlDir = webappDir.concat("/WEB-INF/sql");
                if (Validator.isNull((String)this.serviceFileName)) {
                    this.serviceFileName = webappDir.concat("/WEB-INF/service.xml");
                }
            }
        }
        if (Validator.isNull((String)this.sqlDir)) {
            this.sqlDir = this.baseDir.concat("/src/main/webapp/WEB-INF/sql");
        }
        if (this.pluginType.equals("ext")) {
            if (Validator.isNull((String)this.beanLocatorUtil)) {
                this.beanLocatorUtil = "com.liferay.portal.kernel.bean.PortalBeanLocatorUtil";
            }
            if (Validator.isNull((String)this.propsUtil)) {
                this.propsUtil = "com.liferay.portal.util.PropsUtil";
            }
            if (Validator.isNull((String)this.sqlFileName)) {
                this.sqlFileName = "portal-tables.sql";
            }
            this.pluginName = null;
            this.springBaseFileName = null;
            this.springClusterFileName = null;
            this.springDynamicDataSourceFileName = null;
            this.springHibernateFileName = null;
            this.springInfrastructureFileName = null;
            this.springShardDataSourceFileName = null;
        } else {
            webappDir = this.baseDir.concat("/src/main/webapp");
            webappResourcesDir = this.baseDir.concat("/src/main/resources");
            if (Validator.isNull((String)this.beanLocatorUtil)) {
                this.beanLocatorUtil = "com.liferay.util.bean.PortletBeanLocatorUtil";
            }
            if (Validator.isNull((String)this.hbmFileName)) {
                this.hbmFileName = webappResourcesDir.concat("/META-INF/portlet-hbm.xml");
            }
            if (Validator.isNull((String)this.implDir)) {
                this.implDir = this.baseDir.concat("/src/main/java");
                this.implResourcesDir = this.baseDir.concat("/src/main/resources");
            }
            if (Validator.isNull((String)this.jsonFileName)) {
                this.jsonFileName = webappDir.concat("/js/service.js");
            }
            if (Validator.isNull((String)this.modelHintsFileName)) {
                this.modelHintsFileName = webappResourcesDir.concat("/META-INF/portlet-model-hints.xml");
            }
            if (Validator.isNull((String)this.ormFileName)) {
                this.ormFileName = webappResourcesDir.concat("/META-INF/portlet-orm.xml");
            }
            if (Validator.isNull((String)this.propsUtil)) {
                this.propsUtil = "com.liferay.util.service.ServiceProps";
            }
            if (Validator.isNull((String)this.serviceFileName)) {
                this.serviceFileName = webappDir.concat("/WEB-INF/service.xml");
            }
            if (Validator.isNull((String)this.springBaseFileName)) {
                this.springBaseFileName = webappResourcesDir.concat("/META-INF/base-spring.xml");
            }
            if (Validator.isNull((String)this.springClusterFileName)) {
                this.springClusterFileName = webappResourcesDir.concat("/META-INF/cluster-spring.xml");
            }
            if (Validator.isNull((String)this.springDynamicDataSourceFileName)) {
                this.springDynamicDataSourceFileName = webappResourcesDir.concat("/META-INF/dynamic-data-source-spring.xml");
            }
            if (Validator.isNull((String)this.springFileName)) {
                this.springFileName = webappResourcesDir.concat("/META-INF/portlet-spring.xml");
            }
            if (Validator.isNull((String)this.springHibernateFileName)) {
                this.springHibernateFileName = webappResourcesDir.concat("/META-INF/hibernate-spring.xml");
            }
            if (Validator.isNull((String)this.springInfrastructureFileName)) {
                this.springInfrastructureFileName = webappResourcesDir.concat("/META-INF/infrastructure-spring.xml");
            }
            if (Validator.isNull((String)this.springShardDataSourceFileName)) {
                this.springShardDataSourceFileName = webappResourcesDir.concat("/META-INF/shard-data-source-spring.xml");
            }
            if (Validator.isNull((String)this.sqlFileName)) {
                this.sqlFileName = "tables.sql";
            }
        }
    }

    protected void invokeDependencyBuild() throws Exception {
        if (!this.postBuildDependencyModules) {
            return;
        }
        this.getLog().warn((CharSequence)"Invoker is no longer supported by Maven 3 and will be removed in future builds.");
        ArrayList dependencies = new ArrayList();
        MavenProject parentProject = this.project.getParent();
        if (parentProject == null) {
            return;
        }
        String groupId = this.project.getGroupId();
        List modules = parentProject.getModules();
        ArrayList<String> reactorIncludes = new ArrayList<String>();
        for (Object dependencyObj : this.project.getDependencies()) {
            Dependency dependency = (Dependency)dependencyObj;
            if (!groupId.equals(dependency.getGroupId()) || !modules.contains(dependency.getArtifactId())) continue;
            reactorIncludes.add(dependency.getArtifactId() + "/pom.xml");
        }
        if (reactorIncludes.isEmpty()) {
            return;
        }
        DefaultInvocationRequest invocationRequest = new DefaultInvocationRequest();
        invocationRequest.activateReactor(reactorIncludes.toArray(new String[0]), null);
        invocationRequest.setBaseDirectory(parentProject.getBasedir());
        if (this.postBuildGoals == null) {
            this.postBuildGoals = new ArrayList<String>();
            this.postBuildGoals.add("install");
        }
        invocationRequest.setGoals(this.postBuildGoals);
        invocationRequest.setRecursive(false);
        MavenCommandLineBuilder mavenCommandLineBuilder = new MavenCommandLineBuilder();
        this.getLog().info((CharSequence)("Executing " + mavenCommandLineBuilder.build((InvocationRequest)invocationRequest)));
        InvocationResult invocationResult = this.invoker.execute((InvocationRequest)invocationRequest);
        if (invocationResult.getExecutionException() != null) {
            throw invocationResult.getExecutionException();
        }
        if (invocationResult.getExitCode() != 0) {
            throw new MojoExecutionException("Exit code " + invocationResult.getExitCode());
        }
    }

    protected void moveServicePropertiesFile() {
        File servicePropertiesFile = new File(this.implDir, "service.properties");
        if (servicePropertiesFile.exists()) {
            FileUtil.move((File)servicePropertiesFile, (File)new File(this.implResourcesDir, "service.properties"));
        }
    }
}

