/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.ServiceBuilderMojo;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.WSDDBuilder;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class WSDDBuilderMojo
extends AbstractMojo {
    private MavenProject project;
    private String resourcesDir;
    private String serverConfigFileName;
    private String serviceFileName;
    private String serviceNamespace;

    public void execute() throws MojoExecutionException {
        try {
            this.initClassLoader();
            this.initPortal();
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void doExecute() throws Exception {
        WSDDBuilder wsddBuilder = new WSDDBuilder();
        wsddBuilder.setFileName(this.serviceFileName);
        wsddBuilder.setOutputPath(this.resourcesDir + "/");
        wsddBuilder.setServerConfigFileName(this.serverConfigFileName);
        wsddBuilder.setServiceNamespace(this.serviceNamespace);
        wsddBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClassLoader() throws Exception {
        Class<ServiceBuilderMojo> clazz = ServiceBuilderMojo.class;
        synchronized (ServiceBuilderMojo.class) {
            Class<?> clazz2 = ((Object)((Object)this)).getClass();
            URLClassLoader classLoader = (URLClassLoader)clazz2.getClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (Object object : this.project.getCompileClasspathElements()) {
                String path = (String)object;
                File file = new File(path);
                URI uri = file.toURI();
                method.invoke((Object)classLoader, uri.toURL());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initPortal() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        HtmlUtil htmlUtil = new HtmlUtil();
        htmlUtil.setHtml((Html)new HtmlImpl());
        SAXReaderUtil saxReaderUtil = new SAXReaderUtil();
        saxReaderUtil.setSAXReader((SAXReader)new SAXReaderImpl());
    }
}

