/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bi.reporting;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReportFormat {
    CSV("csv"),
    EXCEL("excel"),
    HTML("html"),
    PDF("pdf"),
    RTF("rtf"),
    TEXT("text"),
    XML("xml");

    private static final Map<String, ReportFormat> _reportFormats;
    private String _value;

    static {
        _reportFormats = new HashMap<String, ReportFormat>();
        _reportFormats.put(CSV.toString(), CSV);
        _reportFormats.put(EXCEL.toString(), EXCEL);
        _reportFormats.put(HTML.toString(), HTML);
        _reportFormats.put(PDF.toString(), PDF);
        _reportFormats.put(RTF.toString(), RTF);
        _reportFormats.put(TEXT.toString(), TEXT);
        _reportFormats.put(XML.toString(), XML);
    }

    public static ReportFormat parse(String value) {
        ReportFormat reportFormat = _reportFormats.get(value);
        if (reportFormat != null) {
            return reportFormat;
        }
        if (EXCEL.toString().equalsIgnoreCase(value)) {
            return EXCEL;
        }
        if (HTML.toString().equalsIgnoreCase(value)) {
            return HTML;
        }
        if (PDF.toString().equalsIgnoreCase(value)) {
            return PDF;
        }
        throw new IllegalArgumentException("Invalid format " + value);
    }

    public String toString() {
        return this._value;
    }

    private ReportFormat(String value) {
        this._value = value;
    }
}

