/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;

public class DayAndPosition
implements Cloneable,
Serializable {
    private int day;
    private int position;
    public static final int NO_WEEKDAY = 0;

    public DayAndPosition() {
        this.day = 0;
        this.position = 0;
    }

    public DayAndPosition(int d, int p) {
        if (!DayAndPosition.isValidDayOfWeek(d)) {
            throw new IllegalArgumentException("Invalid day of week");
        }
        if (!DayAndPosition.isValidDayPosition(p)) {
            throw new IllegalArgumentException("Invalid day position");
        }
        this.day = d;
        this.position = p;
    }

    public int getDayOfWeek() {
        return this.day;
    }

    public void setDayOfWeek(int d) {
        if (!DayAndPosition.isValidDayOfWeek(d)) {
            throw new IllegalArgumentException("Invalid day of week");
        }
        this.day = d;
    }

    public int getDayPosition() {
        return this.position;
    }

    public void setDayPosition(int p) {
        if (!DayAndPosition.isValidDayPosition(p)) {
            throw new IllegalArgumentException();
        }
        this.position = p;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DayAndPosition)) {
            return false;
        }
        DayAndPosition that = (DayAndPosition)obj;
        return this.getDayOfWeek() == that.getDayOfWeek() && this.getDayPosition() == that.getDayPosition();
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this.day);
        hashCode.append(this.position);
        return hashCode.toHashCode();
    }

    public static boolean isValidDayOfWeek(int d) {
        switch (d) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidDayPosition(int p) {
        return p >= -53 && p <= 53;
    }

    public Object clone() {
        try {
            DayAndPosition other = (DayAndPosition)super.clone();
            other.day = this.day;
            other.position = this.position;
            return other;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(6);
        sb.append(this.getClass().getName());
        sb.append("[day=");
        sb.append(this.day);
        sb.append(",position=");
        sb.append(this.position);
        sb.append("]");
        return sb.toString();
    }
}

