/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.util.Validator;
import javax.portlet.RenderResponse;

public class RowChecker {
    public static final String ALIGN = "left";
    public static final String VALIGN = "middle";
    public static final int COLSPAN = 1;
    public static final String FORM_NAME = "fm";
    public static final String ALL_ROW_IDS = "allRowIds";
    public static final String ROW_IDS = "rowIds";
    private String _align;
    private String _valign;
    private int _colspan;
    private String _formName;
    private String _allRowsId;
    private String _rowId;

    public RowChecker(RenderResponse renderResponse) {
        this(renderResponse, ALIGN, VALIGN, 1, FORM_NAME, ALL_ROW_IDS, ROW_IDS);
    }

    public RowChecker(RenderResponse renderResponse, String align, String valign, String formName, String allRowsId, String rowId) {
        this(renderResponse, align, valign, 1, formName, allRowsId, rowId);
    }

    public RowChecker(RenderResponse renderResponse, String align, String valign, int colspan, String formName, String allRowsId, String rowId) {
        this._align = align;
        this._valign = valign;
        this._colspan = colspan;
        this._formName = String.valueOf(renderResponse.getNamespace()) + formName;
        if (Validator.isNotNull(allRowsId)) {
            this._allRowsId = String.valueOf(renderResponse.getNamespace()) + allRowsId;
        }
        this._rowId = String.valueOf(renderResponse.getNamespace()) + rowId;
    }

    public String getAlign() {
        return this._align;
    }

    public String getValign() {
        return this._valign;
    }

    public int getColspan() {
        return this._colspan;
    }

    public String getFormName() {
        return this._formName;
    }

    public String getAllRowsId() {
        return this._allRowsId;
    }

    public String getRowId() {
        return this._rowId;
    }

    public String getAllRowsCheckBox() {
        if (Validator.isNull(this._allRowsId)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<input name=\"");
        sb.append(this._allRowsId);
        sb.append("\" type=\"checkbox\" ");
        sb.append("onClick=\"Liferay.Util.checkAll(");
        sb.append("AUI().one(this).ancestor('");
        sb.append("table.taglib-search-iterator'), '");
        sb.append(this._rowId);
        sb.append("', this");
        sb.append(");\">");
        return sb.toString();
    }

    public String getRowCheckBox(boolean checked, String primaryKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("<input ");
        if (checked) {
            sb.append("checked ");
        }
        sb.append("name=\"");
        sb.append(this._rowId);
        sb.append("\" type=\"checkbox\" value=\"");
        sb.append(primaryKey);
        sb.append("\" ");
        if (Validator.isNotNull(this._allRowsId)) {
            sb.append("onClick=\"Liferay.Util.checkAllBox(");
            sb.append("AUI().one(this).ancestor('");
            sb.append("table.taglib-search-iterator'), '");
            sb.append(this._rowId);
            sb.append("', ");
            sb.append(this._allRowsId);
            sb.append(");\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public boolean isChecked(Object obj) {
        return false;
    }
}

