/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.io.unsync.UnsyncFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnsyncBufferedInputStream
extends UnsyncFilterInputStream {
    protected byte[] buffer;
    protected int firstInvalidIndex;
    protected int index;
    protected int markIndex = -1;
    protected int markLimit;
    private static int _DEFAULT_BUFFER_SIZE = 8192;
    private static int _MAX_MARK_WASTE_SIZE = 4096;

    public UnsyncBufferedInputStream(InputStream inputStream) {
        this(inputStream, _DEFAULT_BUFFER_SIZE);
    }

    public UnsyncBufferedInputStream(InputStream inputStream, int size) {
        super(inputStream);
        this.buffer = new byte[size];
    }

    public int available() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        return this.inputStream.available() + (this.firstInvalidIndex - this.index);
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        this.buffer = null;
    }

    public void mark(int readLimit) {
        this.markLimit = readLimit;
        this.markIndex = this.index;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (this.index >= this.firstInvalidIndex) {
            this.readUnderlyingInputStream();
            if (this.index >= this.firstInvalidIndex) {
                return -1;
            }
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byteArray) throws IOException {
        return this.read(byteArray, 0, byteArray.length);
    }

    public int read(byte[] byteArray, int offset, int length) throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (length <= 0) {
            return 0;
        }
        int read = 0;
        while (true) {
            int available;
            if ((available = this.firstInvalidIndex - this.index) + read >= length) {
                int leftSize = length - read;
                System.arraycopy(this.buffer, this.index, byteArray, offset + read, leftSize);
                this.index += leftSize;
                return length;
            }
            if (available <= 0) {
                this.readUnderlyingInputStream();
                available = this.firstInvalidIndex - this.index;
                if (available > 0) continue;
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            System.arraycopy(this.buffer, this.index, byteArray, offset + read, available);
            this.index += available;
            read += available;
        }
    }

    public void reset() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (this.markIndex < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.index = this.markIndex;
    }

    public long skip(long skip) throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (skip <= 0L) {
            return 0L;
        }
        long available = this.firstInvalidIndex - this.index;
        if (available > 0L) {
            if (available < skip) {
                skip = available;
            }
        } else if (this.markIndex < 0) {
            skip = this.inputStream.skip(skip);
        } else {
            this.readUnderlyingInputStream();
            available = this.firstInvalidIndex - this.index;
            if (available > 0L && available < skip) {
                skip = available;
            }
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }

    protected void readUnderlyingInputStream() throws IOException {
        if (this.markIndex < 0) {
            this.firstInvalidIndex = 0;
            this.index = 0;
            int number = this.inputStream.read(this.buffer);
            if (number > 0) {
                this.firstInvalidIndex = number;
            }
            return;
        }
        if (this.index >= this.buffer.length) {
            if (this.firstInvalidIndex - this.markIndex > this.markLimit) {
                this.markIndex = -1;
                this.index = 0;
            } else if (this.markIndex > _MAX_MARK_WASTE_SIZE) {
                int realDataSize = this.index - this.markIndex;
                System.arraycopy(this.buffer, this.markIndex, this.buffer, 0, realDataSize);
                this.markIndex = 0;
                this.index = realDataSize;
            } else {
                int newBufferSize = this.index << 1;
                if (newBufferSize - _MAX_MARK_WASTE_SIZE > this.markLimit) {
                    newBufferSize = this.markLimit + _MAX_MARK_WASTE_SIZE;
                }
                byte[] newBuffer = new byte[newBufferSize];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.index);
                this.buffer = newBuffer;
            }
        }
        this.firstInvalidIndex = this.index;
        int number = this.inputStream.read(this.buffer, this.index, this.buffer.length - this.index);
        if (number > 0) {
            this.firstInvalidIndex += number;
        }
    }
}

