/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class SearchContextFactory {
    public static SearchContext getInstance(HttpServletRequest request) {
        SearchContext searchContext = new SearchContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        searchContext.setCompanyId(themeDisplay.getCompanyId());
        searchContext.setGroupIds(new long[]{themeDisplay.getScopeGroupId()});
        searchContext.setUserId(themeDisplay.getUserId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = request.getParameterValues(param);
            if (values == null || values.length <= 0) continue;
            if (values.length == 1) {
                attributes.put(param, (Serializable)((Object)values[0]));
                continue;
            }
            attributes.put(param, (Serializable)values);
        }
        searchContext.setAttributes(attributes);
        long[] assetCategoryIds = StringUtil.split(ParamUtil.getString(request, "assetCategoryIds"), 0L);
        String[] assetTagNames = StringUtil.split(ParamUtil.getString(request, "assetTagNames"));
        searchContext.setAssetCategoryIds(assetCategoryIds);
        searchContext.setAssetTagNames(assetTagNames);
        return searchContext;
    }
}

