/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchEngineCommand;
import com.liferay.portal.kernel.search.messaging.SearchRequest;

public class SearchReaderMessageListener
extends BaseSearchEngineMessageListener {
    private static Log _log = LogFactoryUtil.getLog(SearchReaderMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error("Unable to process message " + message, e);
        }
    }

    protected void doCommandSearch(Message message, SearchRequest searchRequest) throws Exception {
        Hits hits = this.searchEngine.getSearcher().search(searchRequest.getCompanyId(), searchRequest.getQuery(), searchRequest.getSorts(), searchRequest.getStart(), searchRequest.getEnd());
        Message responseMessage = MessageBusUtil.createResponseMessage(message, hits);
        MessageBusUtil.sendMessage(responseMessage.getDestinationName(), responseMessage);
    }

    protected void doReceive(Message message) throws Exception {
        Object payload = message.getPayload();
        if (!(payload instanceof SearchRequest)) {
            return;
        }
        SearchRequest searchRequest = (SearchRequest)payload;
        SearchEngineCommand searchEnginecommand = searchRequest.getSearchEngineCommand();
        if (searchEnginecommand.equals((Object)SearchEngineCommand.SEARCH)) {
            this.doCommandSearch(message, searchRequest);
        }
    }
}

