/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.messaging;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.messaging.SearchEngineCommand;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequest
implements Serializable {
    private long _companyId;
    private Document _document;
    private Collection<Document> _documents;
    private int _end;
    private String _id;
    private Collection<String> _ids;
    private Query _query;
    private SearchEngineCommand _searchEngineCommand;
    private Sort[] _sorts;
    private int _start;

    public static SearchRequest addDocument(long companyId, Document document) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.ADD_DOCUMENT);
        searchRequest.setCompanyId(companyId);
        searchRequest.setDocument(document);
        return searchRequest;
    }

    public static SearchRequest addDocuments(long companyId, Collection<Document> documents) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.ADD_DOCUMENTS);
        searchRequest.setCompanyId(companyId);
        searchRequest.setDocuments(documents);
        return searchRequest;
    }

    public static SearchRequest deleteDocument(long companyId, String uid) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.DELETE_DOCUMENT);
        searchRequest.setCompanyId(companyId);
        searchRequest.setId(uid);
        return searchRequest;
    }

    public static SearchRequest deleteDocuments(long companyId, Collection<String> uids) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.DELETE_DOCUMENTS);
        searchRequest.setCompanyId(companyId);
        searchRequest.setIds(uids);
        return searchRequest;
    }

    public static SearchRequest deletePortletDocuments(long companyId, String portletId) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.DELETE_PORTLET_DOCUMENTS);
        searchRequest.setCompanyId(companyId);
        searchRequest.setId(portletId);
        return searchRequest;
    }

    public static SearchRequest search(long companyId, Query query, Sort[] sorts, int start, int end) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.SEARCH);
        searchRequest.setCompanyId(companyId);
        searchRequest.setEnd(end);
        searchRequest.setQuery(query);
        searchRequest.setSorts(sorts);
        searchRequest.setStart(start);
        return searchRequest;
    }

    public static SearchRequest updateDocument(long companyId, Document document) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.UPDATE_DOCUMENT);
        searchRequest.setCompanyId(companyId);
        searchRequest.setDocument(document);
        return searchRequest;
    }

    public static SearchRequest updateDocuments(long companyId, Collection<Document> documents) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.UPDATE_DOCUMENTS);
        searchRequest.setCompanyId(companyId);
        searchRequest.setDocuments(documents);
        return searchRequest;
    }

    private SearchRequest(SearchEngineCommand searchEngineCommand) {
        this._searchEngineCommand = searchEngineCommand;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Document getDocument() {
        return this._document;
    }

    public Collection<Document> getDocuments() {
        return this._documents;
    }

    public int getEnd() {
        return this._end;
    }

    public String getId() {
        return this._id;
    }

    public Collection<String> getIds() {
        return this._ids;
    }

    public Query getQuery() {
        return this._query;
    }

    public SearchEngineCommand getSearchEngineCommand() {
        return this._searchEngineCommand;
    }

    public Sort[] getSorts() {
        return this._sorts;
    }

    public int getStart() {
        return this._start;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setDocument(Document document) {
        this._document = document;
    }

    public void setDocuments(Collection<Document> documents) {
        this._documents = documents;
    }

    public void setEnd(int end) {
        this._end = end;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setIds(Collection<String> ids) {
        this._ids = ids;
    }

    public void setQuery(Query query) {
        this._query = query;
    }

    public void setSorts(Sort[] sorts) {
        this._sorts = sorts;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public String toString() {
        StringBundler sb = new StringBundler(17);
        sb.append("{companyId=");
        sb.append(this._companyId);
        sb.append(", document=");
        sb.append(this._document);
        sb.append(", documents=");
        sb.append(this._documents);
        sb.append(", end=");
        sb.append(this._end);
        sb.append(", id=");
        sb.append(this._id);
        sb.append(", ids=");
        sb.append(this._ids);
        sb.append(", query=");
        sb.append(this._query);
        sb.append(", searchEngineCommand=");
        sb.append((Object)this._searchEngineCommand);
        sb.append(", sorts=");
        sb.append(Arrays.toString(this._sorts));
        sb.append(", start=");
        sb.append(this._start);
        sb.append("}");
        return sb.toString();
    }
}

