/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchEngineCommand;
import com.liferay.portal.kernel.search.messaging.SearchRequest;
import java.util.Collection;

public class SearchWriterMessageListener
extends BaseSearchEngineMessageListener {
    private static Log _log = LogFactoryUtil.getLog(SearchWriterMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error("Unable to process message " + message, e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        Object payload = message.getPayload();
        if (!(payload instanceof SearchRequest)) {
            return;
        }
        SearchRequest searchRequest = (SearchRequest)payload;
        SearchEngineCommand searchEngineCommand = searchRequest.getSearchEngineCommand();
        long companyId = searchRequest.getCompanyId();
        Document document = searchRequest.getDocument();
        Collection<Document> documents = searchRequest.getDocuments();
        String id = searchRequest.getId();
        Collection<String> ids = searchRequest.getIds();
        IndexWriter indexWriter = this.searchEngine.getWriter();
        if (searchEngineCommand.equals((Object)SearchEngineCommand.ADD_DOCUMENT)) {
            indexWriter.addDocument(companyId, document);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.ADD_DOCUMENTS)) {
            indexWriter.addDocuments(companyId, documents);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.DELETE_DOCUMENT)) {
            indexWriter.deleteDocument(companyId, id);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.DELETE_DOCUMENTS)) {
            indexWriter.deleteDocuments(companyId, ids);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.DELETE_PORTLET_DOCUMENTS)) {
            indexWriter.deletePortletDocuments(companyId, id);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.UPDATE_DOCUMENT)) {
            indexWriter.updateDocument(companyId, document);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.UPDATE_DOCUMENTS)) {
            indexWriter.updateDocuments(companyId, documents);
        }
    }
}

