/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import java.io.IOException;
import java.sql.SQLException;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeProcess.class);

    public int getThreshold() {
        return 0;
    }

    public long increment() throws SystemException {
        DB db = DBFactoryUtil.getDB();
        return db.increment();
    }

    public boolean isSupportsAlterColumnName() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsAlterColumnName();
    }

    public boolean isSupportsAlterColumnType() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsAlterColumnType();
    }

    public boolean isSupportsStringCaseSensitiveQuery() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsStringCaseSensitiveQuery();
    }

    public boolean isSupportsUpdateWithInnerJoin() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsUpdateWithInnerJoin();
    }

    public void runSQL(String template) throws IOException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQL(template);
    }

    public void runSQL(String[] templates) throws IOException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQL(templates);
    }

    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQLTemplate(path);
    }

    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQLTemplate(path, failOnError);
    }

    public void upgrade() throws UpgradeException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info("Upgrading " + this.getClass().getName());
            }
            this.doUpgrade();
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
    }

    public void upgrade(Class<?> upgradeProcessClass) throws UpgradeException {
        UpgradeProcess upgradeProcess = null;
        try {
            upgradeProcess = (UpgradeProcess)upgradeProcessClass.newInstance();
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
        upgradeProcess.upgrade();
    }

    public void upgrade(UpgradeProcess upgradeProcess) throws UpgradeException {
        upgradeProcess.upgrade();
    }

    protected void doUpgrade() throws Exception {
    }
}

