/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.HashMap;
import java.util.Map;

public class InstancePool {
    private static Log _log = LogFactoryUtil.getLog(InstancePool.class);
    private static InstancePool _instance = new InstancePool();
    private Map<String, Object> _classPool = new HashMap<String, Object>();

    public static boolean contains(String className) {
        return _instance._contains(className);
    }

    public static Object get(String className) {
        return _instance._get(className);
    }

    public static Object get(String className, boolean logErrors) {
        return _instance._get(className, logErrors);
    }

    public static void put(String className, Object obj) {
        _instance._put(className, obj);
    }

    public static void reset() {
        _instance = new InstancePool();
    }

    private InstancePool() {
    }

    private boolean _contains(String className) {
        className = className.trim();
        return this._classPool.containsKey(className);
    }

    private Object _get(String className) {
        return this._get(className, true);
    }

    private Object _get(String className, boolean logErrors) {
        Object obj;
        block6: {
            obj = this._classPool.get(className = className.trim());
            if (obj == null) {
                ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
                try {
                    Class<?> classObj = portalClassLoader.loadClass(className);
                    obj = classObj.newInstance();
                    this._put(className, obj);
                }
                catch (Exception e1) {
                    if (logErrors && _log.isWarnEnabled()) {
                        _log.warn("Unable to load " + className + " with the portal class loader", e1);
                    }
                    Thread currentThread = Thread.currentThread();
                    ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                    try {
                        Class<?> classObj = contextClassLoader.loadClass(className);
                        obj = classObj.newInstance();
                        this._put(className, obj);
                    }
                    catch (Exception e2) {
                        if (!logErrors) break block6;
                        _log.error("Unable to load " + className + " with the portal class loader or the " + "current context class loader", e2);
                    }
                }
            }
        }
        return obj;
    }

    private void _put(String className, Object obj) {
        className = className.trim();
        this._classPool.put(className, obj);
    }
}

