/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class MathUtil {
    private static Log _log = LogFactoryUtil.getLog(MathUtil.class);
    private static Map<Long, Integer> _base2LogValues = new HashMap<Long, Integer>();

    static {
        _base2LogValues.put(0L, Integer.MIN_VALUE);
        int i = 0;
        while (i < 63) {
            _base2LogValues.put(MathUtil.base2Pow(i), i);
            ++i;
        }
    }

    public static int base2Log(long x) {
        return _base2LogValues.get(x);
    }

    public static long base2Pow(int x) {
        if (x == 0) {
            return 1L;
        }
        return 2L << x - 1;
    }

    public static int factorial(int x) {
        if (x < 0) {
            return 0;
        }
        int factorial = 1;
        while (x > 1) {
            factorial *= x;
            --x;
        }
        return factorial;
    }

    public static double format(double x, int max, int min) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(max);
        nf.setMinimumFractionDigits(min);
        try {
            Number number = nf.parse(nf.format(x));
            x = number.doubleValue();
        }
        catch (Exception e) {
            _log.error(e.getMessage());
        }
        return x;
    }

    public static boolean isEven(int x) {
        return x % 2 == 0;
    }

    public static boolean isOdd(int x) {
        return !MathUtil.isEven(x);
    }

    public static int[] generatePrimes(int max) {
        if (max < 2) {
            return new int[0];
        }
        boolean[] crossedOut = new boolean[max + 1];
        int i = 2;
        while (i < crossedOut.length) {
            crossedOut[i] = false;
            ++i;
        }
        int limit = (int)Math.sqrt(crossedOut.length);
        int i2 = 2;
        while (i2 <= limit) {
            if (!crossedOut[i2]) {
                int multiple = 2 * i2;
                while (multiple < crossedOut.length) {
                    crossedOut[multiple] = true;
                    multiple += i2;
                }
            }
            ++i2;
        }
        int uncrossedCount = 0;
        int i3 = 2;
        while (i3 < crossedOut.length) {
            if (!crossedOut[i3]) {
                ++uncrossedCount;
            }
            ++i3;
        }
        int[] result = new int[uncrossedCount];
        int i4 = 2;
        int j = 0;
        while (i4 < crossedOut.length) {
            if (!crossedOut[i4]) {
                result[j++] = i4;
            }
            ++i4;
        }
        return result;
    }
}

