/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodTargetClassKey {
    private int _hashCode;
    private Method _method;
    private Class<?> _targetClass;
    private Method _targetMethod;
    private String _toString;

    public MethodTargetClassKey(Method method, Class<?> targetClass) {
        this._method = method;
        this._targetClass = targetClass;
        if (this._targetClass != null) {
            try {
                this._targetMethod = this._targetClass.getDeclaredMethod(this._method.getName(), this._method.getParameterTypes());
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodTargetClassKey)) {
            return false;
        }
        MethodTargetClassKey methodTargetClassKey = (MethodTargetClassKey)obj;
        return Validator.equals(this._method, methodTargetClassKey._method) && Validator.equals(this._targetClass, methodTargetClassKey._targetClass);
    }

    public Method getMethod() {
        return this._method;
    }

    public Class<?> getTargetClass() {
        return this._targetClass;
    }

    public Method getTargetMethod() {
        return this._targetMethod;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int hashCode = 77;
            if (this._method != null) {
                hashCode += this._method.hashCode();
            }
            hashCode *= 11;
            if (this._targetClass != null) {
                hashCode += this._targetClass.hashCode();
            }
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }

    public String toString() {
        if (this._toString == null) {
            Class<?>[] parameterTypes = this._method.getParameterTypes();
            StringBundler sb = new StringBundler(parameterTypes.length * 2 + 6);
            sb.append(this._method.getDeclaringClass().getName());
            sb.append(".");
            sb.append(this._method.getName());
            sb.append("(");
            int i = 0;
            while (i < parameterTypes.length) {
                sb.append(parameterTypes[i].getName());
                if (i + 1 < parameterTypes.length) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append(")");
            if (this._targetClass != null) {
                sb.append("@");
                sb.append(this._targetClass.getName());
            }
            this._toString = sb.toString();
        }
        return this._toString;
    }
}

