/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeProperties
extends HashMap<String, String> {
    private static final String _SAFE_NEWLINE_CHARACTER = "_SAFE_NEWLINE_CHARACTER_";
    private static Log _log = LogFactoryUtil.getLog(UnicodeProperties.class);
    private boolean _safe = false;
    private int _length;

    public UnicodeProperties() {
    }

    public UnicodeProperties(boolean safe) {
        this._safe = safe;
    }

    public void fastLoad(String props) {
        if (Validator.isNull(props)) {
            return;
        }
        int x = props.indexOf(10);
        int y = 0;
        while (x != -1) {
            this.put(props.substring(y, x));
            y = x;
            x = props.indexOf(10, y + 1);
        }
        this.put(props.substring(y));
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return this.getProperty(key);
        }
        return defaultValue;
    }

    public boolean isSafe() {
        return this._safe;
    }

    public void load(String props) throws IOException {
        if (Validator.isNull(props)) {
            return;
        }
        UnsyncBufferedReader unsyncBufferedReader = null;
        try {
            unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(props));
            String line = unsyncBufferedReader.readLine();
            while (line != null) {
                this.put(line);
                line = unsyncBufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            if (unsyncBufferedReader != null) {
                try {
                    unsyncBufferedReader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (unsyncBufferedReader != null) {
            try {
                unsyncBufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private void put(String line) {
        if (!this._isComment(line = line.trim())) {
            int pos = line.indexOf(61);
            if (pos != -1) {
                String key = line.substring(0, pos).trim();
                String value = line.substring(pos + 1).trim();
                if (this._safe) {
                    value = UnicodeProperties._decode(value);
                }
                this.setProperty(key, value);
            } else {
                _log.error("Invalid property on line " + line);
            }
        }
    }

    @Override
    public String put(String key, String value) {
        if (key == null) {
            return null;
        }
        if (value == null) {
            return this.remove(key);
        }
        this._length += key.length() + value.length() + 2;
        return super.put(key, value);
    }

    @Override
    public String remove(Object key) {
        if (key == null || !this.containsKey(key)) {
            return null;
        }
        String keyString = (String)key;
        String value = (String)super.remove(key);
        this._length -= keyString.length() + value.length() + 2;
        return value;
    }

    public String setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._length);
        for (Map.Entry entry : this.entrySet()) {
            String value = (String)entry.getValue();
            if (!Validator.isNotNull(value)) continue;
            if (this._safe) {
                value = UnicodeProperties._encode(value);
            }
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected int getToStringLength() {
        return this._length;
    }

    private static String _decode(String value) {
        return StringUtil.replace(value, _SAFE_NEWLINE_CHARACTER, "\n");
    }

    private static String _encode(String value) {
        return StringUtil.replace(value, new String[]{"\r\n", "\n", "\r"}, new String[]{_SAFE_NEWLINE_CHARACTER, _SAFE_NEWLINE_CHARACTER, _SAFE_NEWLINE_CHARACTER});
    }

    private boolean _isComment(String line) {
        return line.length() == 0 || line.startsWith("#");
    }
}

