/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.memory.EqualityWeakReference;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValueConcurrentHashMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private transient Set<Map.Entry<K, V>> _entrySet;
    private final ConcurrentMap<K, Reference<V>> _map;
    private transient Collection<V> _values;

    public WeakValueConcurrentHashMap() {
        this._map = new ConcurrentHashMap<K, Reference<V>>();
    }

    public WeakValueConcurrentHashMap(int initialCapacity) {
        this._map = new ConcurrentHashMap<K, Reference<V>>(initialCapacity);
    }

    public WeakValueConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this._map = new ConcurrentHashMap<K, Reference<V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public WeakValueConcurrentHashMap(Map<? extends K, ? extends V> map) {
        this._map = new ConcurrentHashMap<K, Reference<V>>();
        this.putAll(map);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(new EqualityWeakReference<Object>(value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new UnwrapEntrySet();
        }
        return this._entrySet;
    }

    @Override
    public V get(Object key) {
        Reference valueReference = (Reference)this._map.get(key);
        if (valueReference != null) {
            return (V)valueReference.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this._map.keySet();
    }

    @Override
    public V put(K key, V value) {
        Reference<V> valueReference = this.wrapValue(key, value);
        if ((valueReference = this._map.putIfAbsent(key, valueReference)) != null) {
            return valueReference.get();
        }
        return null;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            Reference<V> valueReference = this.wrapValue(key, value);
            this._map.put(key, valueReference);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Reference<V> valueReference = this.wrapValue(key, value);
        if ((valueReference = this._map.putIfAbsent(key, valueReference)) != null) {
            return valueReference.get();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Reference valueReference = (Reference)this._map.remove(key);
        if (valueReference != null) {
            valueReference.get();
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Reference<V> valueReference = this.wrapValue(key, value);
        return this._map.remove(key, valueReference);
    }

    @Override
    public V replace(K key, V value) {
        Reference<V> valueReference = this.wrapValue(key, value);
        if ((valueReference = this._map.replace(key, valueReference)) != null) {
            return valueReference.get();
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Reference<V> oldValueReference = this.wrapValue(key, oldValue);
        Reference<V> newValueReference = this.wrapValue(key, newValue);
        return this._map.replace(key, oldValueReference, newValueReference);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<V> values() {
        if (this._values == null) {
            this._values = new UnwrapValues();
        }
        return this._values;
    }

    protected Reference<V> wrapValue(Object key, Object value) {
        return FinalizeManager.register(value, new RemoveEntryFinalizeAction(key));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveEntryFinalizeAction
    implements FinalizeAction {
        private final K _key;

        public RemoveEntryFinalizeAction(K key) {
            this._key = key;
        }

        @Override
        public void doFinalize() {
            WeakValueConcurrentHashMap.this.remove(this._key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnwrapEntry
    implements Map.Entry<K, V> {
        private Map.Entry<K, Reference<V>> _entry;

        public UnwrapEntry(Map.Entry<K, Reference<V>> entry) {
            this._entry = entry;
        }

        @Override
        public K getKey() {
            return this._entry.getKey();
        }

        @Override
        public V getValue() {
            Reference valueReference = this._entry.getValue();
            if (valueReference != null) {
                return valueReference.get();
            }
            return null;
        }

        @Override
        public V setValue(V value) {
            return WeakValueConcurrentHashMap.this.put(this._entry.getKey(), value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnwrapEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, Reference<V>>> _iterator;

        public UnwrapEntryIterator() {
            this._iterator = WeakValueConcurrentHashMap.this._map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new UnwrapEntry(this._iterator.next());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnwrapEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private UnwrapEntrySet() {
        }

        @Override
        public void clear() {
            WeakValueConcurrentHashMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = WeakValueConcurrentHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new UnwrapEntryIterator();
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return WeakValueConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return WeakValueConcurrentHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            ArrayList list = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list.toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnwrapValueIterator
    implements Iterator<V> {
        private Iterator<Reference<V>> _iterator;

        public UnwrapValueIterator() {
            this._iterator = WeakValueConcurrentHashMap.this._map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public V next() {
            Reference valueReference = this._iterator.next();
            if (valueReference != null) {
                return valueReference.get();
            }
            return null;
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnwrapValues
    extends AbstractCollection<V> {
        private UnwrapValues() {
        }

        @Override
        public void clear() {
            WeakValueConcurrentHashMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            return WeakValueConcurrentHashMap.this.containsValue(obj);
        }

        @Override
        public Iterator<V> iterator() {
            return new UnwrapValueIterator();
        }

        @Override
        public int size() {
            return WeakValueConcurrentHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList list = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list.toArray(a);
        }
    }
}

