/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util.comparator;

import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.journal.model.JournalArticle;

public class ArticleDisplayDateComparator
extends OrderByComparator {
    public static String ORDER_BY_ASC = "displayDate ASC, version ASC";
    public static String ORDER_BY_DESC = "displayDate DESC, version DESC";
    public static String[] ORDER_BY_FIELDS = new String[]{"displayDate", "version"};
    private boolean _ascending;

    public ArticleDisplayDateComparator() {
        this(false);
    }

    public ArticleDisplayDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        JournalArticle article1 = (JournalArticle)obj1;
        JournalArticle article2 = (JournalArticle)obj2;
        int value = DateUtil.compareTo(article1.getDisplayDate(), article2.getDisplayDate());
        if (value == 0) {
            if (article1.getVersion() < article2.getVersion()) {
                value = -1;
            } else if (article1.getVersion() > article2.getVersion()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

