/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bi.reporting.messaging;

import com.liferay.portal.kernel.bi.reporting.ReportDesignRetriever;
import com.liferay.portal.kernel.bi.reporting.ReportEngine;
import com.liferay.portal.kernel.bi.reporting.ReportGenerationException;
import com.liferay.portal.kernel.bi.reporting.ReportRequest;
import com.liferay.portal.kernel.bi.reporting.ReportResultContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;

public class ReportCompilerRequestMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(ReportCompilerRequestMessageListener.class);
    private ReportEngine _reportEngine;
    private ReportResultContainer _reportResultContainer;

    public void setReportEngine(ReportEngine reportEngine) {
        this._reportEngine = reportEngine;
    }

    public void setReportResultContainer(ReportResultContainer reportResultContainer) {
        this._reportResultContainer = reportResultContainer;
    }

    protected void doReceive(Message message) throws Exception {
        ReportRequest reportRequest = (ReportRequest)message.getPayload();
        ReportDesignRetriever reportDesignRetriever = reportRequest.getReportDesignRetriever();
        ReportResultContainer reportResultContainer = this._reportResultContainer.clone(reportDesignRetriever.getReportName());
        try {
            try {
                this._reportEngine.compile(reportRequest);
            }
            catch (ReportGenerationException rge) {
                _log.error("Unable to compile report", rge);
                reportResultContainer.setReportGenerationException(rge);
                Message responseMessage = MessageBusUtil.createResponseMessage(message, reportResultContainer);
                responseMessage.setPayload(reportResultContainer);
                MessageBusUtil.sendMessage(responseMessage.getDestinationName(), responseMessage);
            }
        }
        finally {
            Message responseMessage = MessageBusUtil.createResponseMessage(message, reportResultContainer);
            responseMessage.setPayload(reportResultContainer);
            MessageBusUtil.sendMessage(responseMessage.getDestinationName(), responseMessage);
        }
    }
}

