/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterExecutorUtil {
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorUtil.class);
    private static ClusterExecutor _clusterExecutor;

    public static void addClusterEventListener(ClusterEventListener clusterEventListener) {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return;
        }
        _clusterExecutor.addClusterEventListener(clusterEventListener);
    }

    public static void destroy() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return;
        }
        _clusterExecutor.destroy();
    }

    public static FutureClusterResponses execute(ClusterRequest clusterRequest) throws SystemException {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor.execute(clusterRequest);
    }

    public static List<Address> getClusterNodeAddresses() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return Collections.emptyList();
        }
        return _clusterExecutor.getClusterNodeAddresses();
    }

    public static List<ClusterNode> getClusterNodes() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return Collections.emptyList();
        }
        return _clusterExecutor.getClusterNodes();
    }

    public static ClusterNode getLocalClusterNode() throws SystemException {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor.getLocalClusterNode();
    }

    public static Address getLocalClusterNodeAddress() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor.getLocalClusterNodeAddress();
    }

    public static void initialize() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return;
        }
        _clusterExecutor.initialize();
    }

    public static boolean isClusterNodeAlive(Address address) {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return false;
        }
        return _clusterExecutor.isClusterNodeAlive(address);
    }

    public static boolean isClusterNodeAlive(String clusterNodeId) {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return false;
        }
        return _clusterExecutor.isClusterNodeAlive(clusterNodeId);
    }

    public static boolean isEnabled() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return false;
        }
        return true;
    }

    public static void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return;
        }
        _clusterExecutor.removeClusterEventListener(clusterEventListener);
    }

    public void setClusterExecutor(ClusterExecutor clusterExecutor) {
        _clusterExecutor = clusterExecutor;
    }
}

