/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.InetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterNode
implements Comparable<ClusterNode>,
Serializable {
    private String _clusterNodeId;
    private String _hostName;
    private InetAddress _inetAddress;
    private int _port;

    public ClusterNode(String clusterNodeId) {
        this._clusterNodeId = clusterNodeId;
    }

    @Override
    public int compareTo(ClusterNode clusterNode) {
        InetAddress inetAddress = clusterNode._inetAddress;
        String ipAddress = inetAddress.getHostAddress();
        String curIpAddress = this._inetAddress.getHostAddress();
        int value = curIpAddress.compareTo(ipAddress);
        if (value == 0) {
            if (this._port > clusterNode._port) {
                value = 1;
            } else if (this._port < clusterNode._port) {
                value = -1;
            }
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode clusterNode = (ClusterNode)obj;
        return Validator.equals(this._clusterNodeId, clusterNode._clusterNodeId);
    }

    public String getClusterNodeId() {
        return this._clusterNodeId;
    }

    public String getHostName() {
        return this._hostName;
    }

    public InetAddress getInetAddress() {
        return this._inetAddress;
    }

    public int getPort() {
        return this._port;
    }

    public int hashCode() {
        return this._clusterNodeId.hashCode();
    }

    public void setHostName(String hostName) {
        this._hostName = hostName;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this._inetAddress = inetAddress;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{clusterNodeId=");
        sb.append(this._clusterNodeId);
        sb.append(", hostName=");
        sb.append(this._hostName);
        sb.append(", inetAddress=");
        sb.append(this._inetAddress);
        sb.append(", port=");
        sb.append(this._port);
        sb.append("}");
        return sb.toString();
    }
}

