/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureClusterResponses
implements Future<ClusterNodeResponses> {
    private boolean _cancelled;
    private ClusterNodeResponses _clusterNodeResponses = new ClusterNodeResponses();
    private CountDownLatch _countDownLatch;
    private Set<Address> _expectedReplyAddress;

    public FutureClusterResponses(List<Address> addresses) {
        this._countDownLatch = new CountDownLatch(addresses.size());
        this._expectedReplyAddress = new HashSet<Address>(addresses);
    }

    public void addClusterNodeResponse(ClusterNodeResponse clusterNodeResponse) {
        this._clusterNodeResponses.addClusterResponse(clusterNodeResponse);
        this._countDownLatch.countDown();
    }

    public void addExpectedReplyAddress(Address address) {
        this._expectedReplyAddress.add(address);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this._cancelled || this.isDone()) {
            return false;
        }
        this._cancelled = true;
        return true;
    }

    public boolean expectsReply(Address address) {
        return this._expectedReplyAddress.contains(address);
    }

    @Override
    public ClusterNodeResponses get() throws InterruptedException {
        if (this._cancelled) {
            throw new CancellationException();
        }
        this._countDownLatch.await();
        return this._clusterNodeResponses;
    }

    @Override
    public ClusterNodeResponses get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (this._cancelled) {
            throw new CancellationException();
        }
        if (this._countDownLatch.await(timeout, timeUnit)) {
            return this._clusterNodeResponses;
        }
        throw new TimeoutException();
    }

    public BlockingQueue<ClusterNodeResponse> getPartialResults() {
        return this._clusterNodeResponses.getClusterResponses();
    }

    @Override
    public boolean isCancelled() {
        return this._cancelled;
    }

    @Override
    public boolean isDone() {
        return this._countDownLatch.getCount() == 0L || this._cancelled;
    }
}

