/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinderPath {
    private static final String _ARGS_SEPARATOR = "_A_";
    private static final String _PARAMS_SEPARATOR = "_P_";
    private String _cacheKeyPrefix;
    private String _cacheName;
    private long _columnBitmask;
    private boolean _entityCacheEnabled;
    private boolean _finderCacheEnabled;
    private String _localCacheKeyPrefix;
    private String _methodName;
    private String[] _params;
    private Class<?> _resultClass;

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, Class<?> resultClass, String cacheName, String methodName, String[] params) {
        this(entityCacheEnabled, finderCacheEnabled, resultClass, cacheName, methodName, params, -1L);
    }

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, Class<?> resultClass, String cacheName, String methodName, String[] params, long columnBitmask) {
        this._entityCacheEnabled = entityCacheEnabled;
        this._finderCacheEnabled = finderCacheEnabled;
        this._resultClass = resultClass;
        this._cacheName = cacheName;
        this._methodName = methodName;
        this._params = params;
        this._columnBitmask = columnBitmask;
        this._initCacheKeyPrefix();
        this._initLocalCacheKeyPrefix();
    }

    public Serializable encodeCacheKey(Object[] args) {
        StringBundler sb = new StringBundler(args.length * 2 + 3);
        sb.append(ShardUtil.getCurrentShardName());
        sb.append(".");
        sb.append(this._cacheKeyPrefix);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(".");
            sb.append(StringUtil.toHexString(arg));
            ++n2;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(FinderCache.class.getName());
        return cacheKeyGenerator.getCacheKey(sb);
    }

    public Serializable encodeLocalCacheKey(Object[] args) {
        StringBundler sb = new StringBundler(args.length * 2 + 3);
        sb.append(ShardUtil.getCurrentShardName());
        sb.append(".");
        sb.append(this._localCacheKeyPrefix);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(".");
            sb.append(StringUtil.toHexString(arg));
            ++n2;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(FinderCache.class.getName());
        return cacheKeyGenerator.getCacheKey(sb);
    }

    public String getCacheName() {
        return this._cacheName;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String[] getParams() {
        return this._params;
    }

    public Class<?> getResultClass() {
        return this._resultClass;
    }

    public boolean isEntityCacheEnabled() {
        return this._entityCacheEnabled;
    }

    public boolean isFinderCacheEnabled() {
        return this._finderCacheEnabled;
    }

    private void _initCacheKeyPrefix() {
        StringBundler sb = new StringBundler(this._params.length * 2 + 3);
        sb.append(this._methodName);
        sb.append(_PARAMS_SEPARATOR);
        String[] stringArray = this._params;
        int n = this._params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            sb.append(".");
            sb.append(param);
            ++n2;
        }
        sb.append(_ARGS_SEPARATOR);
        this._cacheKeyPrefix = sb.toString();
    }

    private void _initLocalCacheKeyPrefix() {
        this._localCacheKeyPrefix = this._cacheName.concat(".").concat(this._cacheKeyPrefix);
    }
}

