/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployScanner;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDeployDir {
    public static final String DEFAULT_NAME = "defaultAutoDeployDir";
    private static Log _log = LogFactoryUtil.getLog(AutoDeployDir.class);
    private List<AutoDeployListener> _autoDeployListeners;
    private AutoDeployScanner _autoDeployScanner;
    private Set<String> _blacklistFiles;
    private int _blacklistThreshold;
    private File _deployDir;
    private File _destDir;
    private Map<String, IntegerWrapper> _inProcessFiles;
    private long _interval;
    private String _name;

    public AutoDeployDir(String name, File deployDir, File destDir, long interval, int blacklistThreshold, List<AutoDeployListener> autoDeployListeners) {
        this._name = name;
        this._deployDir = deployDir;
        this._destDir = destDir;
        this._interval = interval;
        this._blacklistThreshold = blacklistThreshold;
        this._autoDeployListeners = new CopyOnWriteArrayList<AutoDeployListener>(autoDeployListeners);
        this._inProcessFiles = new HashMap<String, IntegerWrapper>();
        this._blacklistFiles = new HashSet<String>();
    }

    public int getBlacklistThreshold() {
        return this._blacklistThreshold;
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getDestDir() {
        return this._destDir;
    }

    public long getInterval() {
        return this._interval;
    }

    public List<AutoDeployListener> getListeners() {
        return this._autoDeployListeners;
    }

    public String getName() {
        return this._name;
    }

    public void registerListener(AutoDeployListener listener) {
        this._autoDeployListeners.add(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (!this._deployDir.exists()) {
            boolean created;
            if (_log.isInfoEnabled()) {
                _log.info("Creating missing directory " + this._deployDir);
            }
            if (!(created = this._deployDir.mkdirs())) {
                _log.error("Directory " + this._deployDir + " could not be created");
            }
        }
        if (this._interval > 0L) {
            try {
                Thread currentThread = Thread.currentThread();
                this._autoDeployScanner = new AutoDeployScanner(currentThread.getThreadGroup(), AutoDeployScanner.class.getName(), this);
                this._autoDeployScanner.start();
                if (!_log.isInfoEnabled()) return;
                _log.info("Auto deploy scanner started for " + this._deployDir);
                return;
            }
            catch (Exception e) {
                _log.error(e, e);
                this.stop();
                return;
            }
        } else {
            if (!_log.isInfoEnabled()) return;
            _log.info("Auto deploy scanning is disabled for " + this._deployDir);
        }
    }

    public void stop() {
        if (this._autoDeployScanner != null) {
            this._autoDeployScanner.pause();
        }
    }

    public void unregisterListener(AutoDeployListener autoDeployListener) {
        this._autoDeployListeners.remove(autoDeployListener);
    }

    protected void processFile(File file) {
        block15: {
            String fileName = file.getName();
            if (!file.canRead()) {
                _log.error("Unable to read " + fileName);
                return;
            }
            if (!file.canWrite()) {
                _log.error("Unable to write " + fileName);
                return;
            }
            if (this._blacklistFiles.contains(fileName)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Skip processing of " + fileName + " because it is " + "blacklisted. You must restart the server to remove " + "the file from the blacklist.");
                }
                return;
            }
            IntegerWrapper attempt = this._inProcessFiles.get(fileName);
            if (attempt == null) {
                attempt = new IntegerWrapper(1);
                this._inProcessFiles.put(fileName, attempt);
                if (_log.isInfoEnabled()) {
                    _log.info("Processing " + fileName);
                }
            } else if (_log.isInfoEnabled()) {
                _log.info("Processing " + fileName + ". This is attempt " + attempt.getValue() + ".");
            }
            try {
                for (AutoDeployListener autoDeployListener : this._autoDeployListeners) {
                    autoDeployListener.deploy(file, null);
                }
                if (file.delete()) {
                    this._inProcessFiles.remove(fileName);
                } else {
                    _log.error("Auto deploy failed to remove " + fileName);
                    if (_log.isInfoEnabled()) {
                        _log.info("Add " + fileName + " to the blacklist");
                    }
                    this._blacklistFiles.add(fileName);
                }
            }
            catch (Exception e) {
                _log.error(e, e);
                attempt.increment();
                if (attempt.getValue() < this._blacklistThreshold) break block15;
                if (_log.isInfoEnabled()) {
                    _log.info("Add " + fileName + " to the blacklist");
                }
                this._blacklistFiles.add(fileName);
            }
        }
    }

    protected void scanDirectory() {
        File[] files;
        File[] fileArray = files = this._deployDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName().toLowerCase();
            if (file.isFile() && (fileName.endsWith(".jar") || fileName.endsWith(".lpkg") || fileName.endsWith(".war") || fileName.endsWith(".xml") || fileName.endsWith(".zip"))) {
                this.processFile(file);
            }
            ++n2;
        }
    }
}

