/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHotDeployListener
implements HotDeployListener {
    public void throwHotDeployException(HotDeployEvent event, String msg, Throwable t) throws HotDeployException {
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        throw new HotDeployException(String.valueOf(msg) + servletContextName, t);
    }

    protected String getClpServletContextName(Class<?> clpMessageListenerClass, MessageListener clpMessageListener) throws Exception {
        Exception e = null;
        try {
            Method servletContextNameMethod = clpMessageListenerClass.getMethod("getServletContextName", new Class[0]);
            String clpServletContextName = (String)servletContextNameMethod.invoke(null, new Object[0]);
            return clpServletContextName;
        }
        catch (Exception e1) {
            e = e1;
            try {
                Field servletContextNameField = clpMessageListenerClass.getField("SERVLET_CONTEXT_NAME");
                String clpServletContextName = servletContextNameField.get(clpMessageListener).toString();
                return clpServletContextName;
            }
            catch (Exception exception) {
                throw e;
            }
        }
    }

    protected Object newInstance(ClassLoader portletClassLoader, Class<?> interfaceClass, String implClassName) throws Exception {
        return ProxyFactory.newInstance(portletClassLoader, interfaceClass, implClassName);
    }

    protected Object newInstance(ClassLoader portletClassLoader, Class<?>[] interfaceClasses, String implClassName) throws Exception {
        return ProxyFactory.newInstance(portletClassLoader, interfaceClasses, implClassName);
    }

    protected void registerClpMessageListeners(ServletContext servletContext, ClassLoader portletClassLoader) throws Exception {
        ArrayList<MessageListener> clpMessageListeners = (ArrayList<MessageListener>)servletContext.getAttribute("CLP_MESSAGE_LISTENERS");
        if (clpMessageListeners != null) {
            return;
        }
        clpMessageListeners = new ArrayList<MessageListener>();
        Set<String> classNames = ServletContextUtil.getClassNames(servletContext);
        for (String className : classNames) {
            MessageListener clpMessageListener;
            Class<?> clpMessageListenerClass;
            String clpServletContextName;
            if (!className.endsWith(".ClpMessageListener") || (clpServletContextName = this.getClpServletContextName(clpMessageListenerClass = portletClassLoader.loadClass(className), clpMessageListener = (MessageListener)clpMessageListenerClass.newInstance())).equals(servletContext.getServletContextName())) continue;
            clpMessageListeners.add(clpMessageListener);
            MessageBusUtil.registerMessageListener("liferay/hot_deploy", clpMessageListener);
        }
        servletContext.setAttribute("CLP_MESSAGE_LISTENERS", clpMessageListeners);
    }

    protected void unregisterClpMessageListeners(ServletContext servletContext) throws Exception {
        List clpMessageListeners = (List)servletContext.getAttribute("CLP_MESSAGE_LISTENERS");
        if (clpMessageListeners != null) {
            servletContext.removeAttribute("CLP_MESSAGE_LISTENERS");
            for (MessageListener clpMessageListener : clpMessageListeners) {
                MessageBusUtil.unregisterMessageListener("liferay/hot_deploy", clpMessageListener);
            }
        }
    }
}

