/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageTool;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ImageToolUtil {
    private static ImageTool _imageProcessor;

    public static BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        return ImageToolUtil.getImageProcessor().convertImageType(sourceImage, type);
    }

    public static void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        ImageToolUtil.getImageProcessor().encodeGIF(renderedImage, os);
    }

    public static void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws InterruptedException, IOException {
        ImageToolUtil.getImageProcessor().encodeWBMP(renderedImage, os);
    }

    public static BufferedImage getBufferedImage(RenderedImage renderedImage) {
        return ImageToolUtil.getImageProcessor().getBufferedImage(renderedImage);
    }

    public static byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        return ImageToolUtil.getImageProcessor().getBytes(renderedImage, contentType);
    }

    public static ImageTool getImageProcessor() {
        return _imageProcessor;
    }

    public static ImageBag read(File file) throws IOException {
        return ImageToolUtil.getImageProcessor().read(file);
    }

    public static ImageBag read(byte[] bytes) throws IOException {
        return ImageToolUtil.getImageProcessor().read(bytes);
    }

    public static RenderedImage scale(RenderedImage renderedImage, int width) {
        return ImageToolUtil.getImageProcessor().scale(renderedImage, width);
    }

    public static RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        return ImageToolUtil.getImageProcessor().scale(renderedImage, maxHeight, maxWidth);
    }

    public void setImageProcessor(ImageTool imageProcessor) {
        _imageProcessor = imageProcessor;
    }
}

