/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.increment;

import com.liferay.portal.kernel.increment.Increment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberIncrement
implements Increment<Number> {
    private Number _value = 0;

    public NumberIncrement(Number value) {
        this._value = value;
    }

    @Override
    public void decrease(Number delta) {
        this._value = this.subtract(delta);
    }

    @Override
    public Increment<Number> decreaseForNew(Number delta) {
        return new NumberIncrement(this.subtract(delta));
    }

    @Override
    public Number getValue() {
        return this._value;
    }

    @Override
    public void increase(Number delta) {
        this._value = this.add(delta);
    }

    @Override
    public Increment<Number> increaseForNew(Number delta) {
        return new NumberIncrement(this.add(delta));
    }

    @Override
    public void setValue(Number value) {
        this._value = value;
    }

    protected Number add(Number delta) {
        if (delta instanceof Double) {
            return this.addAsDouble(delta);
        }
        if (delta instanceof Integer) {
            return this.addAsInteger(delta);
        }
        if (delta instanceof Long) {
            return this.addAsLong(delta);
        }
        return this._value;
    }

    protected Number addAsDouble(Number delta) {
        if (delta == null) {
            return this._value;
        }
        return this._value.doubleValue() + delta.doubleValue();
    }

    protected Number addAsInteger(Number delta) {
        if (delta == null) {
            return this._value;
        }
        return this._value.intValue() + delta.intValue();
    }

    protected Number addAsLong(Number delta) {
        if (delta == null) {
            return this._value;
        }
        return this._value.longValue() + delta.longValue();
    }

    protected Number subtract(Number delta) {
        if (delta instanceof Double) {
            return this.subtractAsDouble(delta);
        }
        if (delta instanceof Integer) {
            return this.subtractAsInteger(delta);
        }
        if (delta instanceof Long) {
            return this.subtractAsLong(delta);
        }
        return this._value;
    }

    protected Number subtractAsDouble(Number delta) {
        if (delta == null) {
            return this._value;
        }
        return this._value.doubleValue() - delta.doubleValue();
    }

    protected Number subtractAsInteger(Number delta) {
        if (delta == null) {
            return this._value;
        }
        return this._value.intValue() - delta.intValue();
    }

    protected Number subtractAsLong(Number delta) {
        if (delta == null) {
            return this._value;
        }
        return this._value.longValue() - delta.longValue();
    }
}

