/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;

public class OutputStreamWriter
extends Writer {
    private CharsetEncoder _charsetEncoder;
    private String _charsetName;
    private OutputStream _outputStream;

    public OutputStreamWriter(OutputStream outputStream) {
        this(outputStream, "UTF-8");
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName) {
        this._outputStream = outputStream;
        this._charsetName = charsetName;
        this._charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName);
    }

    public void close() throws IOException {
        this._outputStream.close();
    }

    public void flush() throws IOException {
        this._outputStream.flush();
    }

    public String getEncoding() {
        return this._charsetName;
    }

    public void write(char[] chars, int offset, int length) throws IOException {
        ByteBuffer byteBuffer = this._charsetEncoder.encode(CharBuffer.wrap(chars, offset, length));
        this._outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
    }

    public void write(int c) throws IOException {
        ByteBuffer byteBuffer = this._charsetEncoder.encode(CharBuffer.wrap(new char[]{(char)c}));
        this._outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
    }

    public void write(String string, int offset, int length) throws IOException {
        ByteBuffer byteBuffer = this._charsetEncoder.encode(CharBuffer.wrap(string, offset, length));
        this._outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
    }
}

