/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.InputStream;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] buffer;
    protected int capacity;
    protected int index;
    protected int markIndex;

    public UnsyncByteArrayInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.index = 0;
        this.capacity = buffer.length;
    }

    public UnsyncByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.index = offset;
        this.capacity = Math.min(buffer.length, offset + length);
        this.markIndex = offset;
    }

    public int available() {
        return this.capacity - this.index;
    }

    public void mark(int readAheadLimit) {
        this.markIndex = this.index;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        if (this.index < this.capacity) {
            return this.buffer[this.index++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int offset, int length) {
        if (length <= 0) {
            return 0;
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        int read = length;
        if (this.index + read > this.capacity) {
            read = this.capacity - this.index;
        }
        System.arraycopy(this.buffer, this.index, bytes, offset, read);
        this.index += read;
        return read;
    }

    public void reset() {
        this.index = this.markIndex;
    }

    public long skip(long skip) {
        if (skip < 0L) {
            return 0L;
        }
        if (skip + (long)this.index > (long)this.capacity) {
            skip = this.capacity - this.index;
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }
}

