/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.io.OutputStreamWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;

public class UnsyncPrintWriter
extends PrintWriter {
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private Formatter _formatter;
    private boolean _hasError;
    private Writer _writer;

    public UnsyncPrintWriter(File file) throws IOException {
        this(new FileWriter(file));
    }

    public UnsyncPrintWriter(File file, String csn) throws FileNotFoundException {
        this(new OutputStreamWriter(new FileOutputStream(file), csn));
    }

    public UnsyncPrintWriter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public UnsyncPrintWriter(String fileName) throws IOException {
        this(new FileWriter(fileName));
    }

    public UnsyncPrintWriter(String fileName, String csn) throws FileNotFoundException {
        this(new OutputStreamWriter(new FileOutputStream(fileName), csn));
    }

    public UnsyncPrintWriter(Writer writer) {
        super(writer);
        this._writer = writer;
    }

    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    public PrintWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    public PrintWriter append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.write(charSequence.subSequence(start, end).toString());
        return this;
    }

    public boolean checkError() {
        if (this._writer != null) {
            this.flush();
        }
        return this._hasError;
    }

    public void close() {
        try {
            if (this._writer == null) {
                return;
            }
            this._writer.close();
            this._writer = null;
        }
        catch (IOException iOException) {
            this._hasError = true;
        }
    }

    public void flush() {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.flush();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public PrintWriter format(Locale locale, String format, Object ... arguments) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            if (this._formatter == null || this._formatter.locale() != locale) {
                this._formatter = new Formatter(this, locale);
            }
            this._formatter.format(locale, format, arguments);
        }
        return this;
    }

    public PrintWriter format(String format, Object ... arguments) {
        return this.format(Locale.getDefault(), format, arguments);
    }

    public void print(boolean b) {
        if (b) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(char[] chars) {
        this.write(chars);
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public PrintWriter printf(Locale locale, String format, Object ... arguments) {
        return this.format(locale, format, arguments);
    }

    public PrintWriter printf(String format, Object ... arguments) {
        return this.format(format, arguments);
    }

    public void println() {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(_LINE_SEPARATOR);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char[] chars) {
        this.print(chars);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void reset(Writer writer) {
        this._formatter = null;
        this._hasError = false;
        this.out = this._writer = writer;
    }

    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    public void write(char[] chars, int offset, int length) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(chars, offset, length);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void write(int c) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(c);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void write(String string) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(string);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void write(String string, int offset, int length) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(string, offset, length);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }
}

