/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class UnsyncStringReader
extends Reader {
    protected int index;
    protected int stringLength;
    protected int markIndex;
    protected String string;

    public UnsyncStringReader(String string) {
        this.string = string;
        this.stringLength = string.length();
    }

    public void close() {
        this.string = null;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (this.string == null) {
            throw new IOException("String is null");
        }
        this.markIndex = this.index;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.string == null) {
            throw new IOException("String is null");
        }
        if (this.index >= this.stringLength) {
            return -1;
        }
        return this.string.charAt(this.index++);
    }

    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    public int read(char[] chars, int offset, int length) throws IOException {
        if (this.string == null) {
            throw new IOException("String is null");
        }
        if (length <= 0) {
            return 0;
        }
        if (this.index >= this.stringLength) {
            return -1;
        }
        int read = length;
        if (this.index + read > this.stringLength) {
            read = this.stringLength - this.index;
        }
        this.string.getChars(this.index, this.index + read, chars, offset);
        this.index += read;
        return read;
    }

    public int read(CharBuffer charBuffer) throws IOException {
        int remaining = charBuffer.remaining();
        char[] chars = new char[remaining];
        int read = this.read(chars, 0, remaining);
        if (read > 0) {
            charBuffer.put(chars, 0, read);
        }
        return read;
    }

    public boolean ready() throws IOException {
        if (this.string == null) {
            throw new IOException("String is null");
        }
        return true;
    }

    public void reset() throws IOException {
        if (this.string == null) {
            throw new IOException("String is null");
        }
        this.index = this.markIndex;
    }

    public long skip(long skip) {
        if (this.index >= this.stringLength) {
            return 0L;
        }
        if (skip + (long)this.index > (long)this.stringLength) {
            skip = this.stringLength - this.index;
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }
}

