/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageBus
implements MessageBus {
    private static Log _log = LogFactoryUtil.getLog(DefaultMessageBus.class);
    private Set<DestinationEventListener> _destinationEventListeners = new ConcurrentHashSet<DestinationEventListener>();
    private Map<String, Destination> _destinations = new HashMap<String, Destination>();

    @Override
    public synchronized void addDestination(Destination destination) {
        this._destinations.put(destination.getName(), destination);
        this.fireDestinationAddedEvent(destination);
    }

    @Override
    public void addDestinationEventListener(DestinationEventListener destinationEventListener) {
        this._destinationEventListeners.add(destinationEventListener);
    }

    @Override
    public void addDestinationEventListener(String destinationName, DestinationEventListener destinationEventListener) {
        Destination destination = this._destinations.get(destinationName);
        if (destination != null) {
            destination.addDestinationEventListener(destinationEventListener);
        }
    }

    public void destroy() {
        this.shutdown(true);
    }

    @Override
    public Destination getDestination(String destinationName) {
        return this._destinations.get(destinationName);
    }

    @Override
    public int getDestinationCount() {
        return this._destinations.size();
    }

    @Override
    public Collection<String> getDestinationNames() {
        return this._destinations.keySet();
    }

    @Override
    public Collection<Destination> getDestinations() {
        return this._destinations.values();
    }

    @Override
    public boolean hasDestination(String destinationName) {
        return this._destinations.containsKey(destinationName);
    }

    @Override
    public boolean hasMessageListener(String destinationName) {
        Destination destination = this._destinations.get(destinationName);
        return destination != null && destination.isRegistered();
    }

    @Override
    public synchronized boolean registerMessageListener(String destinationName, MessageListener messageListener) {
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            throw new IllegalStateException("Destination " + destinationName + " is not configured");
        }
        boolean registered = destination.register(messageListener);
        if (registered) {
            this.fireMessageListenerRegisteredEvent(destination, messageListener);
        }
        return registered;
    }

    @Override
    public synchronized Destination removeDestination(String destinationName) {
        Destination destinationModel = this._destinations.remove(destinationName);
        destinationModel.removeDestinationEventListeners();
        destinationModel.unregisterMessageListeners();
        this.fireDestinationRemovedEvent(destinationModel);
        return destinationModel;
    }

    @Override
    public void removeDestinationEventListener(DestinationEventListener destinationEventListener) {
        this._destinationEventListeners.remove(destinationEventListener);
    }

    @Override
    public void removeDestinationEventListener(String destinationName, DestinationEventListener destinationEventListener) {
        Destination destination = this._destinations.get(destinationName);
        if (destination != null) {
            destination.removeDestinationEventListener(destinationEventListener);
        }
    }

    @Override
    public void replace(Destination destination) {
        Destination oldDestination = this._destinations.get(destination.getName());
        oldDestination.copyDestinationEventListeners(destination);
        oldDestination.copyMessageListeners(destination);
        this.removeDestination(oldDestination.getName());
        this.addDestination(destination);
    }

    @Override
    public void sendMessage(String destinationName, Message message) {
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Destination " + destinationName + " is not configured");
            }
            return;
        }
        message.setDestinationName(destinationName);
        destination.send(message);
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public synchronized void shutdown(boolean force) {
        for (Destination destination : this._destinations.values()) {
            destination.close(force);
        }
    }

    @Override
    public synchronized boolean unregisterMessageListener(String destinationName, MessageListener messageListener) {
        Destination destination = this._destinations.get(destinationName);
        if (destination == null) {
            return false;
        }
        boolean unregistered = destination.unregister(messageListener);
        if (unregistered) {
            this.fireMessageListenerUnregisteredEvent(destination, messageListener);
        }
        return unregistered;
    }

    protected void fireDestinationAddedEvent(Destination destination) {
        for (DestinationEventListener listener : this._destinationEventListeners) {
            listener.destinationAdded(destination);
        }
    }

    protected void fireDestinationRemovedEvent(Destination destination) {
        for (DestinationEventListener listener : this._destinationEventListeners) {
            listener.destinationRemoved(destination);
        }
    }

    protected void fireMessageListenerRegisteredEvent(Destination destination, MessageListener messageListener) {
        for (DestinationEventListener destinationEventListener : this._destinationEventListeners) {
            destinationEventListener.messageListenerRegistered(destination.getName(), messageListener);
        }
    }

    protected void fireMessageListenerUnregisteredEvent(Destination destination, MessageListener messageListener) {
        for (DestinationEventListener destinationEventListener : this._destinationEventListeners) {
            destinationEventListener.messageListenerUnregistered(destination.getName(), messageListener);
        }
    }
}

