/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessagingConfigurator
implements MessagingConfigurator {
    private List<Destination> _destinations = new ArrayList<Destination>();
    private List<DestinationEventListener> _globalDestinationEventListeners = new ArrayList<DestinationEventListener>();
    private Map<String, List<MessageListener>> _messageListeners = new HashMap<String, List<MessageListener>>();
    private List<Destination> _replacementDestinations = new ArrayList<Destination>();
    private Map<String, List<DestinationEventListener>> _specificDestinationEventListeners = new HashMap<String, List<DestinationEventListener>>();

    public void afterPropertiesSet() {
        MessageBus messageBus = this.getMessageBus();
        for (DestinationEventListener destinationEventListener : this._globalDestinationEventListeners) {
            messageBus.addDestinationEventListener(destinationEventListener);
        }
        for (Destination destination : this._destinations) {
            messageBus.addDestination(destination);
        }
        for (Map.Entry entry : this._specificDestinationEventListeners.entrySet()) {
            String destinationName = (String)entry.getKey();
            for (DestinationEventListener destinationEventListener : (List)entry.getValue()) {
                messageBus.addDestinationEventListener(destinationName, destinationEventListener);
            }
        }
        for (Destination destination : this._replacementDestinations) {
            messageBus.replace(destination);
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        try {
            ClassLoader operatingClassLoader = this.getOperatingClassloader();
            thread.setContextClassLoader(operatingClassLoader);
            for (Map.Entry entry : this._messageListeners.entrySet()) {
                String destinationName = (String)entry.getKey();
                for (MessageListener messageListener : (List)entry.getValue()) {
                    messageBus.registerMessageListener(destinationName, messageListener);
                }
            }
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void destroy() {
        MessageBus messageBus = this.getMessageBus();
        for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
            String destinationName = messageListeners.getKey();
            for (MessageListener messageListener : messageListeners.getValue()) {
                messageBus.unregisterMessageListener(destinationName, messageListener);
            }
        }
        for (Destination destination : this._destinations) {
            messageBus.removeDestination(destination.getName());
            destination.close();
        }
        for (DestinationEventListener destinationEventListener : this._globalDestinationEventListeners) {
            messageBus.removeDestinationEventListener(destinationEventListener);
        }
    }

    @Override
    public void init() {
        this.afterPropertiesSet();
    }

    @Override
    public void setDestinations(List<Destination> destinations) {
        this._destinations = destinations;
    }

    @Override
    public void setGlobalDestinationEventListeners(List<DestinationEventListener> globalDestinationEventListeners) {
        this._globalDestinationEventListeners = globalDestinationEventListeners;
    }

    @Override
    public void setMessageListeners(Map<String, List<MessageListener>> messageListeners) {
        this._messageListeners = messageListeners;
        for (List<MessageListener> messageListenersList : this._messageListeners.values()) {
            for (MessageListener messageListener : messageListenersList) {
                Method setMessageBusMethod;
                Class<?> messageListenerClass = messageListener.getClass();
                try {
                    setMessageBusMethod = messageListenerClass.getMethod("setMessageBus", MessageBus.class);
                    setMessageBusMethod.setAccessible(true);
                    setMessageBusMethod.invoke((Object)messageListener, this.getMessageBus());
                }
                catch (Exception exception) {
                    try {
                        setMessageBusMethod = messageListenerClass.getDeclaredMethod("setMessageBus", MessageBus.class);
                        setMessageBusMethod.setAccessible(true);
                        setMessageBusMethod.invoke((Object)messageListener, this.getMessageBus());
                    }
                    catch (Exception exception2) {}
                }
            }
        }
    }

    @Override
    public void setReplacementDestinations(List<Destination> replacementDestinations) {
        this._replacementDestinations = replacementDestinations;
    }

    @Override
    public void setSpecificDestinationEventListener(Map<String, List<DestinationEventListener>> specificDestinationEventListeners) {
        this._specificDestinationEventListeners = specificDestinationEventListeners;
    }

    protected abstract MessageBus getMessageBus();

    protected abstract ClassLoader getOperatingClassloader();
}

