/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.mobile.device;

import com.liferay.portal.kernel.mobile.device.Capability;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceRecognitionProvider;
import com.liferay.portal.kernel.mobile.device.KnownDevices;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceDetectionUtil {
    private static volatile DeviceRecognitionProvider _deviceRecognitionProvider;

    public static Device detectDevice(HttpServletRequest request) {
        return _deviceRecognitionProvider.detectDevice(request);
    }

    public static Set<VersionableName> getKnownBrands() {
        KnownDevices knownDevices = _deviceRecognitionProvider.getKnownDevices();
        return knownDevices.getBrands();
    }

    public static Set<VersionableName> getKnownBrowsers() {
        KnownDevices knownDevices = _deviceRecognitionProvider.getKnownDevices();
        return knownDevices.getBrowsers();
    }

    public static Set<String> getKnownDeviceIdsByCapability(Capability capability) {
        KnownDevices knownDevices = _deviceRecognitionProvider.getKnownDevices();
        Map<Capability, Set<String>> deviceIds = knownDevices.getDeviceIds();
        return deviceIds.get(capability);
    }

    public static Set<VersionableName> getKnownOperatingSystems() {
        KnownDevices knownDevices = _deviceRecognitionProvider.getKnownDevices();
        return knownDevices.getOperatingSystems();
    }

    public static Set<String> getKnownPointingMethods() {
        KnownDevices knownDevices = _deviceRecognitionProvider.getKnownDevices();
        return knownDevices.getPointingMethods();
    }

    public void setDeviceRecognitionProvider(DeviceRecognitionProvider deviceRecognitionProvider) {
        _deviceRecognitionProvider = deviceRecognitionProvider;
    }
}

