/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.Channel;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseChannelImpl
implements Channel {
    private static Log _log = LogFactoryUtil.getLog(BaseChannelImpl.class);
    private List<ChannelListener> _channelListeners = new CopyOnWriteArrayList<ChannelListener>();
    private long _cleanUpInterval;
    private long _companyId;
    private AtomicLong _nextCleanUpTime = new AtomicLong();
    private long _userId;

    @Override
    public void cleanUp() throws ChannelException {
        long nextCleanUpTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime > (nextCleanUpTime = this._nextCleanUpTime.get()) && this._nextCleanUpTime.compareAndSet(nextCleanUpTime, currentTime + this._cleanUpInterval)) {
            try {
                this.doCleanUp();
            }
            catch (ChannelException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new ChannelException(e);
            }
        }
    }

    @Override
    public void close() throws ChannelException {
        this.flush();
    }

    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public List<NotificationEvent> getNotificationEvents() throws ChannelException {
        return this.getNotificationEvents(true);
    }

    @Override
    public long getUserId() {
        return this._userId;
    }

    public boolean hasNotificationEvents() {
        block3: {
            try {
                List<NotificationEvent> notificationEvents = this.getNotificationEvents(false);
                if (!notificationEvents.isEmpty()) {
                    return true;
                }
            }
            catch (ChannelException ce) {
                if (!_log.isErrorEnabled()) break block3;
                _log.error("Unable to fetch notifications", ce);
            }
        }
        return false;
    }

    @Override
    public void registerChannelListener(ChannelListener channelListener) {
        this._channelListeners.add(channelListener);
        if (this.hasNotificationEvents()) {
            this.notifyChannelListeners();
        }
    }

    public void setCleanUpInterval(long cleanUpInterval) {
        this._cleanUpInterval = cleanUpInterval;
    }

    @Override
    public void unregisterChannelListener(ChannelListener channelListener) {
        this._channelListeners.remove(channelListener);
        channelListener.channelListenerRemoved(this._userId);
    }

    protected BaseChannelImpl(long companyId, long usedId) {
        this._companyId = companyId;
        this._userId = usedId;
    }

    protected abstract void doCleanUp() throws Exception;

    protected void notifyChannelListeners() {
        for (ChannelListener channelListener : this._channelListeners) {
            channelListener.notificationEventsAvailable(this._userId);
        }
    }
}

