/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.plugin;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version>,
Serializable {
    public static final String UNKNOWN = "unknown";
    private static final String _SEPARATOR = ".";
    private static Map<String, Version> _versions = new ConcurrentHashMap<String, Version>();
    private String _bugFix;
    private String _buildNumber;
    private String _major;
    private String _minor;

    public static Version getInstance(String version) {
        Version versionObj = _versions.get(version);
        if (versionObj == null) {
            versionObj = new Version(version);
            _versions.put(version, versionObj);
        }
        return versionObj;
    }

    public static Version incrementBugFix(Version version) {
        String bugFix = version.getBugFix();
        int bugFixInt = GetterUtil.getInteger(bugFix);
        if (bugFixInt > 0) {
            bugFix = String.valueOf(bugFixInt + 1);
        }
        return Version.getInstance(Version._toString(version.getMajor(), version.getMinor(), bugFix, version.getBuildNumber()));
    }

    public static Version incrementBuildNumber(Version version) {
        String buildNumber = version.getBuildNumber();
        int buildNumberInt = GetterUtil.getInteger(buildNumber);
        if (buildNumberInt > 0) {
            buildNumber = String.valueOf(buildNumberInt + 1);
        }
        return Version.getInstance(Version._toString(version.getMajor(), version.getMinor(), version.getBugFix(), buildNumber));
    }

    public static Version incrementMajor(Version version) {
        String major = version.getMajor();
        int majorInt = GetterUtil.getInteger(major);
        if (majorInt > 0) {
            major = String.valueOf(majorInt + 1);
        }
        return Version.getInstance(Version._toString(major, version.getMinor(), version.getBugFix(), version.getBuildNumber()));
    }

    public static Version incrementMinor(Version version) {
        String minor = version.getMinor();
        int minorInt = GetterUtil.getInteger(minor);
        if (minorInt > 0) {
            minor = String.valueOf(minorInt + 1);
        }
        return Version.getInstance(Version._toString(version.getMajor(), minor, version.getBugFix(), version.getBuildNumber()));
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        if (version.toString().equals(UNKNOWN)) {
            return 1;
        }
        if (this.toString().equals(UNKNOWN)) {
            return -1;
        }
        int result = this.getMajor().compareTo(version.getMajor());
        if (result != 0) {
            return result;
        }
        result = this.getMinor().compareTo(version.getMinor());
        if (result != 0) {
            return result;
        }
        result = this.getBugFix().compareTo(version.getBugFix());
        if (result != 0) {
            return result;
        }
        return this.getBuildNumber().compareTo(version.getBuildNumber());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Version)) {
            return false;
        }
        Version version = (Version)obj;
        String versionString1 = this.toString();
        String versionString2 = version.toString();
        if (versionString1.equals(UNKNOWN) || versionString2.equals(UNKNOWN)) {
            return false;
        }
        return versionString1.equals(versionString2);
    }

    public String getBugFix() {
        if (this._bugFix == null) {
            return "0";
        }
        return this._bugFix;
    }

    public String getBuildNumber() {
        return this._buildNumber;
    }

    public String getMajor() {
        if (this._major == null) {
            return "0";
        }
        return this._major;
    }

    public String getMinor() {
        if (this._minor == null) {
            return "0";
        }
        return this._minor;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean includes(Version version) {
        if (this.equals(version)) {
            return true;
        }
        if (this.getMajor().equals("*")) {
            return true;
        }
        if (this.getMajor().equals(version.getMajor())) {
            if (this.getMinor().equals("*")) {
                return true;
            }
            if (this.getMinor().equals(version.getMinor())) {
                if (this.getBugFix().equals("*")) {
                    return true;
                }
                if (this.getBugFix().equals(version.getBugFix()) ? this.getBuildNumber().equals("*") || this.getBuildNumber().equals(version.getBuildNumber()) : Version._contains(this.getBugFix(), version.getBugFix())) {
                    return true;
                }
            } else if (Version._contains(this.getMinor(), version.getMinor())) {
                return true;
            }
        } else if (Version._contains(this.getMajor(), version.getMajor())) {
            return true;
        }
        return false;
    }

    public boolean isLaterVersionThan(String version) {
        return this.compareTo(Version.getInstance(version)) > 0;
    }

    public boolean isPreviousVersionThan(String version) {
        return this.compareTo(Version.getInstance(version)) < 0;
    }

    public boolean isSameVersionAs(String version) {
        return this.compareTo(Version.getInstance(version)) == 0;
    }

    public String toString() {
        return Version._toString(this._major, this._minor, this._bugFix, this._buildNumber);
    }

    protected Version(String version) {
        StringTokenizer st = new StringTokenizer(version, _SEPARATOR);
        this._major = st.nextToken();
        if (st.hasMoreTokens()) {
            this._minor = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this._bugFix = st.nextToken();
        }
        StringBundler sb = new StringBundler();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(_SEPARATOR);
        }
        this._buildNumber = sb.toString();
    }

    private static boolean _contains(String containerString, String numberString) {
        if (containerString.endsWith("+")) {
            String containerNumberString = containerString.substring(0, containerString.length() - 1);
            try {
                int containerNumber = Integer.parseInt(containerNumberString);
                int number = Integer.parseInt(numberString);
                return containerNumber <= number;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private static String _toString(String major, String minor, String bugFix, String buildNumber) {
        StringBundler sb = new StringBundler();
        sb.append(major);
        if (Validator.isNotNull(minor)) {
            sb.append(_SEPARATOR);
            sb.append(minor);
            if (Validator.isNotNull(bugFix)) {
                sb.append(_SEPARATOR);
                sb.append(bugFix);
                if (Validator.isNotNull(buildNumber)) {
                    sb.append(_SEPARATOR);
                    sb.append(buildNumber);
                }
            }
        }
        return sb.toString();
    }
}

