/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller.comet;

import com.liferay.portal.kernel.poller.comet.CometException;
import com.liferay.portal.kernel.poller.comet.CometHandler;
import com.liferay.portal.kernel.poller.comet.CometSession;
import com.liferay.portal.kernel.poller.comet.CometState;

public abstract class BaseCometHandler
implements CometHandler {
    private CometSession _cometSession;
    private CometState _cometState = CometState.STATE_OPEN;

    public abstract CometHandler clone();

    public void destroy() throws CometException {
        this._cometState = CometState.STATE_CLOSED;
        try {
            this.doDestroy();
        }
        catch (CometException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CometException(e);
        }
    }

    public CometSession getCometSession() {
        return this._cometSession;
    }

    public CometState getCometState() {
        return this._cometState;
    }

    public void init(CometSession cometSession) throws CometException {
        this._cometSession = cometSession;
        this._cometState = CometState.STATE_READY;
        try {
            this.doInit(cometSession);
        }
        catch (CometException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CometException(e);
        }
    }

    public void receiveData(char[] data) throws CometException {
        this.receiveData(new String(data));
    }

    protected void doDestroy() throws Exception {
    }

    protected void doInit(CometSession cometSession) throws Exception {
    }
}

