/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalClassLoaderObjectInputStream
extends ObjectInputStream {
    private static final Map<String, Class<?>> _primaryClasses = new HashMap(8, 1.0f);
    private final ClassLoader _portalClassLoader = PortalClassLoaderUtil.getClassLoader();

    static {
        _primaryClasses.put("boolean", Boolean.TYPE);
        _primaryClasses.put("byte", Byte.TYPE);
        _primaryClasses.put("char", Character.TYPE);
        _primaryClasses.put("short", Short.TYPE);
        _primaryClasses.put("int", Integer.TYPE);
        _primaryClasses.put("long", Long.TYPE);
        _primaryClasses.put("float", Float.TYPE);
        _primaryClasses.put("double", Double.TYPE);
        _primaryClasses.put("void", Void.TYPE);
    }

    public PortalClassLoaderObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException {
        String name = objectStreamClass.getName();
        try {
            return Class.forName(name, false, this._portalClassLoader);
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> clazz = _primaryClasses.get(name);
            if (clazz != null) {
                return clazz;
            }
            throw cnfe;
        }
    }
}

