/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ExceptionProcessCallable;
import com.liferay.portal.kernel.process.PortalClassLoaderObjectInputStream;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ReturnProcessCallable;
import com.liferay.portal.kernel.process.log.ProcessOutputStream;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutor {
    private static Log _log = LogFactoryUtil.getLog(ProcessExecutor.class);
    private static volatile ExecutorService _executorService;

    public static <T extends Serializable> T execute(ProcessCallable<T> processCallable, String classPath) throws ProcessException {
        block6: {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder("java", "-cp", classPath, ProcessExecutor.class.getName());
                Process process = processBuilder.start();
                ProcessExecutor._writeObject(process.getOutputStream(), processCallable);
                ExecutorService executorService = ProcessExecutor._getExecutorService();
                SubprocessReactor subprocessReactor = new SubprocessReactor(process.getInputStream());
                Future<ProcessCallable<? extends Serializable>> futureResponseProcessCallable = executorService.submit(subprocessReactor);
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new ProcessException("Subprocess terminated with exit code " + exitCode);
                }
                ProcessCallable<? extends Serializable> responseProcessCallable = futureResponseProcessCallable.get();
                if (responseProcessCallable instanceof ReturnProcessCallable) {
                    return (T)responseProcessCallable.call();
                }
                if (responseProcessCallable instanceof ExceptionProcessCallable) {
                    ExceptionProcessCallable exceptionProcessCallable = (ExceptionProcessCallable)responseProcessCallable;
                    throw exceptionProcessCallable.call();
                }
                if (!_log.isWarnEnabled()) break block6;
                _log.warn("Subprocess reactor exited without a valid return because the subprocess terminated with an exception");
            }
            catch (ProcessException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
        }
        return null;
    }

    public static void main(String[] arguments) throws ClassNotFoundException, IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(System.out);
        ProcessOutputStream outProcessOutputStream = new ProcessOutputStream(objectOutputStream, false);
        PrintStream outPrintStream = new PrintStream(outProcessOutputStream, true);
        System.setOut(outPrintStream);
        ProcessOutputStream errProcessOutputStream = new ProcessOutputStream(objectOutputStream, true);
        PrintStream errPrintStream = new PrintStream(errProcessOutputStream, true);
        System.setErr(errPrintStream);
        try {
            ProcessCallable processCallable = (ProcessCallable)ProcessExecutor._readObject(System.in, false);
            Object result = processCallable.call();
            outPrintStream.flush();
            outProcessOutputStream.writeProcessCallable(new ReturnProcessCallable(result));
            outProcessOutputStream.close();
        }
        catch (ProcessException pe) {
            errPrintStream.flush();
            errProcessOutputStream.writeProcessCallable(new ExceptionProcessCallable(pe));
            errProcessOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (_executorService == null) {
            return;
        }
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            if (_executorService != null) {
                _executorService.shutdownNow();
                _executorService = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService _getExecutorService() {
        if (_executorService != null) {
            return _executorService;
        }
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            if (_executorService == null) {
                _executorService = Executors.newCachedThreadPool(new NamedThreadFactory(ProcessExecutor.class.getName(), 1, PortalClassLoaderUtil.getClassLoader()));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _executorService;
        }
    }

    private static Object _readObject(InputStream inputStream, boolean close) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            Object object = objectInputStream.readObject();
            return object;
        }
        finally {
            if (close) {
                objectInputStream.close();
            }
        }
    }

    private static void _writeObject(OutputStream outputStream, Object object) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        try {
            objectOutputStream.writeObject(object);
        }
        finally {
            objectOutputStream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubprocessReactor
    implements Callable<ProcessCallable<? extends Serializable>> {
        private final UnsyncBufferedInputStream _unsyncBufferedInputStream;

        public SubprocessReactor(InputStream inputStream) {
            this._unsyncBufferedInputStream = new UnsyncBufferedInputStream(inputStream);
        }

        @Override
        public ProcessCallable<? extends Serializable> call() throws Exception {
            try {
                PortalClassLoaderObjectInputStream objectInputStream = null;
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                while (true) {
                    try {
                        this._unsyncBufferedInputStream.mark(4);
                        objectInputStream = new PortalClassLoaderObjectInputStream(this._unsyncBufferedInputStream);
                        if (unsyncByteArrayOutputStream.size() > 0 && _log.isWarnEnabled()) {
                            _log.warn("Found corrupted leading log: " + unsyncByteArrayOutputStream.toString());
                        }
                        unsyncByteArrayOutputStream = null;
                    }
                    catch (StreamCorruptedException streamCorruptedException) {
                        this._unsyncBufferedInputStream.reset();
                        unsyncByteArrayOutputStream.write(this._unsyncBufferedInputStream.read());
                        continue;
                    }
                    break;
                }
                while (true) {
                    ProcessCallable processCallable;
                    if ((processCallable = (ProcessCallable)objectInputStream.readObject()) instanceof ExceptionProcessCallable) {
                        return processCallable;
                    }
                    if (processCallable instanceof ReturnProcessCallable) {
                        return processCallable;
                    }
                    Object result = processCallable.call();
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("Invoked generic process callable " + processCallable + " with return value " + result);
                }
            }
            catch (EOFException eOFException) {
                return null;
            }
        }
    }
}

