/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.log;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingProcessCallable
implements ProcessCallable<String> {
    private static Log _log = LogFactoryUtil.getLog(LoggingProcessCallable.class);
    private final byte[] _bytes;
    private final boolean _error;

    public LoggingProcessCallable(byte[] bytes) {
        this(bytes, false);
    }

    public LoggingProcessCallable(byte[] bytes, boolean error) {
        this._bytes = bytes;
        this._error = error;
    }

    @Override
    public String call() {
        try {
            if (this._error) {
                System.err.write(this._bytes);
            } else {
                System.out.write(this._bytes);
            }
        }
        catch (IOException ioe) {
            _log.error("Unable to output log message: " + new String(this._bytes), ioe);
        }
        return "";
    }
}

